/* Program Example 10.3: Interrupt toggle switch with formatted data logging to text file
                                                                            */

#include "mbed.h"

InterruptIn button(p30);    // Interrupt on digital input 20
DigitalOut led1(LED1);        // digital out to onboard LED1
Timer debounce;          // define debounce timer
LocalFileSystem local("local");           // define local file system

void toggle(void);  // function prototype

int main() {
    debounce.start();
    button.rise(&toggle);      // attach the address of the toggle function to the rising edge
}

void toggle() {
if (debounce.read_ms()>200)
    led1=!led1;
    FILE* Logfile = fopen ("/local/log.txt","a");       // open file for reading
    fprintf(Logfile,"time=%.3fs: button pressed so setting led=%d\n\r",debounce.read(),led1.read());
    fclose(Logfile);
    debounce.reset();
}