/*Program Example 9.7: Demonstrates the use of Timeout and interrupts, to allow response to an event-driven task while a time-driven task continues.
                                                                             */ 
#include "mbed.h"
void blink_end (void);      
void blink (void); 
void ISR1 (void);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
Timeout Response;             //create a Timeout, and name it Response
Timeout Response_duration;    //create a Timeout, and name it Response_duration
InterruptIn button(p5);       //create an interrupt input, named button

void blink() {           //This function is called when Timeout is complete
  led2=1;
  // set the duration of the led blink, with another timeout, duration 0.1 s    
  Response_duration.attach(&blink_end, 1);
}
    
void blink_end() {            //A function called at the end of Timeout Response_duration
  led2=0;
}
    
void ISR1(){
  led3=1;       //shows button is pressed; diagnostic and not central to program
  //attach blink1 function to Response Timeout, to occur after 2 seconds    
  Response.attach(&blink, 2.0);
}
    
int main() {
  button.rise(&ISR1);   //attach the address of ISR1 function to the rising edge
  while(1) {
    led3=0;                //clear LED3 
    led1=!led1;
    wait(0.2);
  }
}

