/* Program Example 9.5: Tests Timer duration, displaying current time values to terminal
                                                                     */ 
#include "mbed.h"

Timer t;
float s=0;                              //seconds cumulative count
float m=0;             //minutes cumulative count
DigitalOut diag (LED1);
Serial pc(USBTX, USBRX);

int main() {
  pc.printf("\r\nTimer Duration Test\n\r");
  pc.printf("-------------------\n\n\r");
  t.reset();            //reset Timer
  t.start();            // start Timer
  while(1){
    if (t.read()>=(s+1)){   //has Timer passed next whole second?
      diag = 1;             //If yes, flash LED and print a message
      wait (0.05);
      diag = 0;
      s++ ;
      //print the number of seconds exceeding whole minutes
      pc.printf("%1.0f seconds\r\n",(s-60*(m-1)));   
    }
    if (t.read()>=60*m){
      printf("%1.0f minutes \n\r",m);   
      m++ ;
    }
    if (t.read()<s){     //test for overflow
      pc.printf("\r\nTimer has overflowed!\n\r");
      for(;;){}         //lock into an endless loop doing nothing
    }
  }            //end of while
}

