/* Program Example 9.2: Tests interrupt latency. External input causes interrupt, which pulses external LED while LED4 flashes continuously.                                                                     
                                                                           */
#include "mbed.h"
InterruptIn squarewave(p5);     //Connect input square wave here
DigitalOut led(p6);
DigitalOut flash(LED4);

void pulse() {                 //ISR sets external led high for fixed duration
  led = 1;
  wait(0.01);
  led = 0;
}

int main() {
  squarewave.rise(&pulse);  // attach the address of the pulse function to
                                                             // the rising edge
  while(1) {                // interrupt will occur within this endless loop
    flash = !flash;
    wait(0.25);
  }
}

