/*Program Example 8.8: Program which reads character from computer screen, and displays on Nokia LCD display. 
                                                                           */
#include "mbed.h"
#include "MobileLCD.h"
MobileLCD lcd(p11, p12, p13, p15, p16); //mosi,miso,clk,cs,rst
Serial pc(USBTX, USBRX);                // host terminal comms setup
char c;                                 // char variable for keyboard input
void screen_setup(void);                // function prototype

int main() {
  pc.printf("\n\rType something to be displayed:\n\r");
  screen_setup();                     // call the screen setup function
  while(1){
    c = pc.getc();             // c = character input from computer keyboard
    wait(0.001);
    if (c=='#'){               // perform the following if "#" is pressed
      screen_setup();          // call the screen setup function
      lcd.locate(0,0);         // move the cursor back to row 0 column 0
    }
    else{
      lcd.printf("%c",c);      // print character on the LCD screen
      pc.printf("%c",c);       // print character on the terminal screen
    }
  }
}

//function definition for screen_setup
void screen_setup(void) {               
  lcd.background(0x0000FF);           // set the background colour
  lcd.cls();                          // clear the screen
}
