#include "LCD.h"

DigitalOut RS(p19);             // RS
DigitalOut RW(p19);             // RW
DigitalOut E(p20);              // Enable
BusOut data(p21, p22, p23, p24);// DB4-DB7

/****initialise LCD function ****/  
void LCD_init(void){  

  wait(0.02);
  RS=0;    // set all low to write control/instruction data
//  RW=0;
  E=0;
     
  // Function set
  data=0x2;            // = 4 bit mode
  toggle_enable();
  data=0x8;            // = 2-line mode, 7 dot characters
  toggle_enable(); 
 
  // Display Mode
  data=0x0;          //                    
  toggle_enable();
  data=0xF;             // display on, cursor on, blink on                    
  toggle_enable();

  // Clear display
  data=0x0;            //
  toggle_enable();
  data=0x1;            // clear 
  toggle_enable();
  
}


/**** display ****/  
void display_to_LCD(char value ){
    
    RS=1;
    //***** display character *****************            
    data=value>>4;       // value shifted right 4 = upper              
    toggle_enable();
    data=value&0x0F;       // value bitmask with 0x0F = lower      
    toggle_enable();
}


/**** toggle enable function ****/  
void toggle_enable(void){
  E=1;
  wait(0.001);
  E=0;
  wait(0.001);
}

/**** set location function ****/                                                                      
void set_location(char location){
    RS=0;
    data=(location|0x80)>>4;             // upper nibble             
    toggle_enable();
    data=location&0x0F;                  // lower nibble      
    toggle_enable();
}
