/* Program Example 6.1: seven-segment display counter 
                                                              */
#include "mbed.h" 

BusOut Seg1(p5,p6,p7,p8,p9,p10,p11,p12); // A,B,C,D,E,F,G,DP
char SegConvert(char SegValue);          // function prototype
char A=0;                               // declare variables A and B
char B;

int main() {                            // main program
  while (1) {                           // infinite loop
    B=SegConvert(A);                    // Call function to return B
    Seg1=B;                             // Output B
    A++;                                // increment A
    if (A>0x09){                        // if A > 9 reset to zero
          A=0;
       }
    wait(0.5);                          // delay 500 milliseconds
  }
}

char SegConvert(char SegValue) {        // function 'SegConvert'
  char SegByte=0x00;
  switch (SegValue) {                   //DP G F E D C B A
    case 0 : SegByte = 0x3F;break;      // 0 0 1 1 1 1 1 1 binary
    case 1 : SegByte = 0x06;break;      // 0 0 0 0 0 1 1 0 binary
    case 2 : SegByte = 0x5B;break;      // 0 1 0 1 1 0 1 1 binary
    case 3 : SegByte = 0x4F;break;      // 0 1 0 0 1 1 1 1 binary
    case 4 : SegByte = 0x66;break;      // 0 1 1 0 0 1 1 0 binary
    case 5 : SegByte = 0x6D;break;      // 0 1 1 0 1 1 0 1 binary
    case 6 : SegByte = 0x7D;break;      // 0 1 1 1 1 1 0 1 binary
    case 7 : SegByte = 0x07;break;      // 0 0 0 0 0 1 1 1 binary
    case 8 : SegByte = 0x7F;break;      // 0 1 1 1 1 1 1 1 binary
    case 9 : SegByte = 0x6F;break;      // 0 1 1 0 1 1 1 1 binary
  }
    return SegByte;
}

