///*
// * rosserial ADC Example
// *
// * This is a poor man's Oscilloscope.  It does not have the sampling
// * rate or accuracy of a commerical scope, but it is great to get
// * an analog value into ROS in a pinch.
// */
//
//#include "mbed.h"
//#include <ros.h>
//#include <geometry_msgs/Vector3Stamped.h>
//#include <ros/time.h>
//
////AnalogIn analog_value1(A0);
////AnalogIn analog_value2(A1);
////AnalogIn analog_value3(A2);
//DigitalOut led(LED1);
//
//ros::NodeHandle nh;
//
//geometry_msgs::Vector3Stamped joint_angle;
//
//ros::Publisher p("adc", &joint_angle);
//
//
////We average the analog reading to elminate some of the noise
//int averageAnalog(PinName pin) {
//    int v=0;
//    for (int i=0; i<4; i++) v+= AnalogIn(pin).read_u16();
//    return v/4;
//}
//
//int main() {
//    nh.initNode();
//    nh.advertise(p);
//
//    while (1) {
//        joint_angle.vector.x= averageAnalog(A0);
//        joint_angle.vector.y= averageAnalog(A1);
//        joint_angle.vector.z= averageAnalog(A2);
//        joint_angle.header.stamp = nh.now();
//        p.publish(&joint_angle);
//        nh.spinOnce();
//        wait_ms(10);
//    }
//}

/*
 * rosserial ADC Example
 *
 * This is a poor man's Oscilloscope.  It does not have the sampling
 * rate or accuracy of a commerical scope, but it is great to get
 * an analog value into ROS in a pinch.
 */

#include "mbed.h"
#include <ros.h>
#include <std_msgs/Float64.h>
#include <ros/time.h>

//AnalogIn analog_value1(A0);
//AnalogIn analog_value2(A1);
//AnalogIn analog_value3(A2);
DigitalOut led(LED1);

ros::NodeHandle nh;

std_msgs::Float64 feedback;

ros::Publisher p("state", &feedback);


//We average the analog reading to elminate some of the noise
int averageAnalog(PinName pin) {
    int v=0;
    for (int i=0; i<4; i++) v+= AnalogIn(pin).read();
    return v*2000/4-1000;
}

int main() {
    nh.initNode();
    nh.advertise(p);

    while (1) {
        feedback.data = averageAnalog(A0);
        p.publish(&feedback);
        nh.spinOnce();
        wait_ms(10);
    }
}

