
#include "mbed.h"
#include "math.h"
#include <string>

Serial FRDM_UART_Debug(USBTX,USBRX);
Serial FRDM_Data_Tx(PTC17,PTC16);
I2C I2C_Bus(PTE25,PTE24);


const int Light_I2C_Addr = 0x88;
float Light_Out = 0;


int main() 
{
    
    FRDM_UART_Debug.baud(115200);           // Baud rate used for communicating with Tera-term on PC
    FRDM_Data_Tx.baud(115200);
    
    I2C_Bus.frequency(100000); // set required i2c frequency
    
    while (1) 
    {
       
        uint16_t Light = 0;
        
        char I2C_Cmd[3];
        int Temp_i_1 = 0;
        int Temp_i_2 = 0;
        int Temp_i_3 = 0;
        int loop_count = 0;
        
        I2C_Cmd[0] = 0x01;   //configuration register
        I2C_Cmd[1]= 0xCC;    //configuration data
        I2C_Cmd[2]= 0x01;   //configuration data
        
        I2C_Bus.write(Light_I2C_Addr, I2C_Cmd, 3);
        
        I2C_Cmd[0] = 0x00; // data register
        
        I2C_Bus.write(Light_I2C_Addr, I2C_Cmd, 1);
        
        wait_ms(100);
        
        I2C_Bus.read(Light_I2C_Addr, I2C_Cmd, 2);
     
        Temp_i_1= I2C_Cmd[0]>>4;
        Temp_i_2= (I2C_Cmd[0]-(Temp_i_1<<4))*256+I2C_Cmd[1];

        for(loop_count = 0,Temp_i_3 = 1 ; loop_count < Temp_i_1 ; Temp_i_3 = Temp_i_3 * 2,loop_count++);
        
        Light_Out= (Temp_i_2 * Temp_i_3) / 100;
        
        Light  = Light_Out;
            
        FRDM_Data_Tx.printf("%d\n",Light);
        FRDM_UART_Debug.printf("Lux = %.2f\n\r", Light_Out);
        
        wait(5);
         
    }
} 