/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "BLEDevice.h"

const static char  DEVICE_NAME[] = "mbed HRM1017";

static const uint16_t KONASHI_SERVICE_UUID              = 0xFF00;

static const uint16_t KONASHI_PIO_SETTING_UUID          = 0x3000;  
static const uint16_t KONASHI_PIO_PULLUP_UUID           = 0x3001;  
static const uint16_t KONASHI_PIO_OUTPUT_UUID           = 0x3002;  
static const uint16_t KONASHI_PIO_INPUT_NOTIFICATION_UUID = 0x3003;  

static const uint16_t KONASHI_PWM_CONFIG_UUID           = 0x3004;  
static const uint16_t KONASHI_PWM_PARAM_UUID            = 0x3005;  
static const uint16_t KONASHI_PWM_DUTY_UUID             = 0x3006;  

static const uint16_t KONASHI_ANALOG_DRIVE_UUID         = 0x3007;  
static const uint16_t KONASHI_ANALOG_READ0_UUID         = 0x3008;  
static const uint16_t KONASHI_ANALOG_READ1_UUID         = 0x3009;  
static const uint16_t KONASHI_ANALOG_READ2_UUID         = 0x300A;  

static const uint16_t KONASHI_I2C_CONFIG_UUID           = 0x300B;  
static const uint16_t KONASHI_I2C_START_STOP_UUID       = 0x300C;  
static const uint16_t KONASHI_I2C_WRITE_UUID            = 0x300D;  
static const uint16_t KONASHI_I2C_READ_PARAM_UIUD       = 0x300E;  
static const uint16_t KONASHI_I2C_READ_UUID             = 0x300F;  

static const uint16_t KONASHI_UART_CONFIG_UUID          = 0x3010;  
static const uint16_t KONASHI_UART_BAUDRATE_UUID        = 0x3011;  
static const uint16_t KONASHI_UART_TX_UUID              = 0x3012;  
static const uint16_t KONASHI_UART_RX_NOTIFICATION_UUID = 0x3013;  

static const uint16_t KONASHI_HARDWARE_RESET_UUID       = 0x3014;  
static const uint16_t KONASHI_HARDWARE_LOW_BAT_NOTIFICATION_UUID = 0x3015; 

uint16_t    uuid16_list[] = { KONASHI_SERVICE_UUID };

#define NEED_CONSOLE_OUTPUT 0 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
Serial  pc(USBTX, USBRX);
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

//Serial  pc(USBTX, USBRX);
BLEDevice  ble;
DigitalOut led1(LED1);
DigitalOut led2(LED2);

BusOut ioOut(P0_0,P0_1,P0_2,P0_3,P0_4,P0_5,P0_6,P0_7);
uint8_t pioSetting[20]      = {0,};
uint8_t pioPullup[20]       = {0,};
uint8_t pioOutput[20]       = {0,};
uint8_t pioInput[20]        = {0,};

uint8_t pwmConfig[20]       = {0,};
uint8_t pwmPeriod[20]       = {0,};
uint8_t pwmDuty[20]         = {0,};
static uint32_t pwm_period[3] = {20000,20000,20000};
static uint32_t pwm_duty[3] = {0,0,0};
static uint8_t  pwm_config = 0;
PwmOut pwm[3] = {P0_28, P0_29, P0_30};

uint8_t analogDrive[20]     = {0,};
uint8_t analogRead0[20]     = {0,};
uint8_t analogRead1[20]     = {0,};
uint8_t analogRead2[20]     = {0,};

uint8_t i2cConfig[20]       = {0,};
uint8_t i2cStartStop[20]    = {0,};
uint8_t i2cWrite[20]        = {0,};
uint8_t i2cReadParam[20]    = {0,};
uint8_t i2cRead[20]         = {0,};

uint8_t uartConfig[20]      = {0,};
uint8_t uartBaudrate[20]    = {0,};
uint8_t uartTx[20]          = {0,};
uint8_t uartRx[20]          = {0,};

uint8_t hardwareRest[20]    = {0,};
uint8_t hardwareLowBat[20]  = {0,};

GattCharacteristic  pioSettingCharacteristic (KONASHI_PIO_SETTING_UUID, pioSetting, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  pioPullupCharacteristic (KONASHI_PIO_PULLUP_UUID, pioPullup, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  pioOutputCharacteristic (KONASHI_PIO_OUTPUT_UUID, pioOutput, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  pioInputCharacteristic (KONASHI_PIO_INPUT_NOTIFICATION_UUID, pioInput, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);

GattCharacteristic  pwmConfigCharacteristic (KONASHI_PWM_CONFIG_UUID, pwmConfig, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  pwmPeriodCharacteristic (KONASHI_PWM_PARAM_UUID, pwmPeriod, 5, 5,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  pwmDutyCharacteristic (KONASHI_PWM_DUTY_UUID, pwmDuty, 5, 5,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);

GattCharacteristic  analogDriveCharacteristic (KONASHI_ANALOG_DRIVE_UUID, analogDrive, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  analogRead0Characteristic (KONASHI_ANALOG_READ0_UUID, analogRead0, 2, 2,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
GattCharacteristic  analogRead1Characteristic (KONASHI_ANALOG_READ1_UUID, analogRead1, 2, 2,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
GattCharacteristic  analogRead2Characteristic (KONASHI_ANALOG_READ2_UUID, analogRead2, 2, 2,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);

GattCharacteristic  i2cConfigCharacteristic (KONASHI_I2C_CONFIG_UUID, i2cConfig, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  i2cStartStopCharacteristic (KONASHI_I2C_START_STOP_UUID, i2cStartStop, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  i2cWriteCharacteristic (KONASHI_I2C_WRITE_UUID, i2cWrite, 3, 20,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  i2cReadParamCharacteristic (KONASHI_I2C_READ_PARAM_UIUD, i2cReadParam, 2, 2,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  i2cReadCharacteristic (KONASHI_I2C_READ_UUID, i2cRead, 0, 20,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);

GattCharacteristic  uartConfigCharacteristic (KONASHI_UART_CONFIG_UUID, uartConfig, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  uartBaudrateCharacteristic (KONASHI_UART_BAUDRATE_UUID, uartBaudrate, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  uartTxCharacteristic (KONASHI_UART_TX_UUID, uartTx, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  uartRxCharacteristic (KONASHI_UART_RX_NOTIFICATION_UUID, uartRx, 0, 20,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);

GattCharacteristic  hardwareRestCharacteristic (KONASHI_HARDWARE_RESET_UUID, hardwareRest, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic  hardwareLowBatCharacteristic (KONASHI_HARDWARE_LOW_BAT_NOTIFICATION_UUID, hardwareLowBat, 1, 1,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);

GattCharacteristic *konashiChars[] = {//  &pioSettingCharacteristic,
                                      //  &pioPullupCharacteristic,
                                        &pioOutputCharacteristic,
                                        &pioInputCharacteristic,
                                        &pwmConfigCharacteristic,
                                        &pwmPeriodCharacteristic,
                                        &pwmDutyCharacteristic,
/*                                        &analogDriveCharacteristic,
                                        &analogRead0Characteristic,
                                        &analogRead1Characteristic,
                                        &analogRead2Characteristic,
                                        &i2cConfigCharacteristic,
                                        &i2cStartStopCharacteristic,
                                        &i2cWriteCharacteristic,
                                        &i2cReadParamCharacteristic,
                                        &i2cReadCharacteristic,
                                        &uartConfigCharacteristic,
                                        &uartBaudrateCharacteristic,
                                        &uartTxCharacteristic,
                                        &uartRxCharacteristic,
                                        &hardwareRestCharacteristic,
                                        &hardwareLowBatCharacteristic,*/  };
GattService         konashiService(KONASHI_SERVICE_UUID, konashiChars, sizeof(konashiChars) / sizeof(GattCharacteristic *));

GattCharacteristic *konashiChars1[] = {&pioOutputCharacteristic, &uartTxCharacteristic, &uartRxCharacteristic};
GattService         konashiService1(KONASHI_SERVICE_UUID, konashiChars1, sizeof(konashiChars1) / sizeof(GattCharacteristic *));


// SYSTEM
static char         systemId = 'A';
GattCharacteristic  systemID(GattCharacteristic::UUID_SYSTEM_ID_CHAR, (uint8_t *)systemId, sizeof(systemId), sizeof(systemId),
                           GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
// MODEL
static char         model[31] = "mbed HRM1017";
GattCharacteristic  modelID(GattCharacteristic::UUID_MODEL_NUMBER_STRING_CHAR, (uint8_t *)model, strlen(model), strlen(model),
                           GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
// Firmware
static char         fwversion[31] = "1.0";
GattCharacteristic  fwChars(GattCharacteristic::UUID_FIRMWARE_REVISION_STRING_CHAR, (uint8_t *)fwversion, strlen(fwversion), strlen(fwversion),
                           GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
// Software
static char         swversion[31] = "1.0";
GattCharacteristic  swChars(GattCharacteristic::UUID_SOFTWARE_REVISION_STRING_CHAR, (uint8_t *)swversion, strlen(swversion), strlen(swversion),
                           GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
// Hardware
static char         hwversion[31] = "1.0";
GattCharacteristic  hwChars(GattCharacteristic::UUID_HARDWARE_REVISION_STRING_CHAR, (uint8_t *)hwversion, strlen(hwversion), strlen(hwversion),
                           GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
// Manufacturer
static char         vendor[31] = "Test Company Inc.";
GattCharacteristic  vendorChars(GattCharacteristic::UUID_MANUFACTURER_NAME_STRING_CHAR, (uint8_t *)vendor, strlen(vendor), strlen(vendor),
                           GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
// Serial number
static char         serial[31] = "1234567890";
GattCharacteristic  serialChars(GattCharacteristic::UUID_SERIAL_NUMBER_STRING_CHAR, (uint8_t *)serial, strlen(serial), strlen(serial),
                           GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);

//GattCharacteristic *informationChars[] = {&systemID, &modelID, &serialChars, &fwChars, &hwChars, &swChars, &vendorChars, };
GattCharacteristic *informationChars[] = {&modelID, &fwChars, &hwChars, &swChars, &vendorChars, };
GattService         informationService(GattService::UUID_DEVICE_INFORMATION_SERVICE, informationChars, sizeof(informationChars) / sizeof(GattCharacteristic *));


static uint8_t      batteryLevel = 100;
GattCharacteristic  batteryPercentage(GattCharacteristic::UUID_BATTERY_LEVEL_CHAR, (uint8_t *)batteryLevel, sizeof(batteryLevel), sizeof(batteryLevel),
                           GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
GattCharacteristic *batteryChars[] = {&batteryPercentage };
GattService         batteryService(GattService::UUID_BATTERY_SERVICE, batteryChars, sizeof(batteryChars) / sizeof(GattCharacteristic *));

void connectionCallback(uint16_t charHandle)
//void connectionCallback(void)
{
    DEBUG("Connected!\n\r");
    led2 = 0;
}
void disconnectionCallback(uint16_t charHandle)
//void disconnectionCallback(void)
{
    DEBUG("Disconnected!\n\r");
    DEBUG("Restarting the advertising process\n\r");
    led2 = 1;
    ble.startAdvertising();
}
static void set_pwm_duty(int ch)
{
//    uint32_t    period;
    uint32_t    duty;
    unsigned    bitmask = 1;

    if(ch>=3){
        return;
    }
    duty=pwm_duty[ch];

    if(pwm_config & (bitmask << ch))
    {
        pwm[ch].pulsewidth_us(duty);
    }
    else
    {
        pwm[ch].pulsewidth_us(0);
     }
 }
static void set_pwm_period(int ch)
{
    uint32_t    period,duty;

    if(ch>=3){
        return;
    }
    period=pwm_period[ch];
    duty=pwm_duty[ch];
    pwm[ch].period_us(period);
    pwm[ch].pulsewidth_us(duty);
}
static void set_pwm_config(uint8_t config)
{
    pwm_config = config;
    for(int i = 0; i < 3 ; i++)
    {
        set_pwm_duty(i);
    }

}
void onDataWritten(uint16_t charHandle)
{
    DEBUG("onDataWritten\n\r");
    if (charHandle == pioOutputCharacteristic.getHandle()) {
        DEBUG("pioOutputCharacteristic!\n\r");
        uint8_t getPioOut[10];
        uint16_t bytesRead;
        ble.readCharacteristicValue(pioOutputCharacteristic.getHandle(), getPioOut, &bytesRead);
        DEBUG("DATA: %d %d\n\r",getPioOut[0],pioOutput[0]);
        if(getPioOut[0]!=pioOutput[0]) {
            pioOutput[0]=getPioOut[0];
            ioOut = getPioOut[0];
        }
/*    } else if (charHandle == pioSettingCharacteristic.getHandle()) {
        DEBUG("pioSettingCharacteristic!\n\r");
    } else if (charHandle == pioPullupCharacteristic.getHandle()) {
        DEBUG("pioPullupCharacteristic!\n\r");*/
    } else if (charHandle == pwmConfigCharacteristic.getHandle()) {
        DEBUG("pwmConfigCharacteristic!\n\r");
        uint16_t bytesRead;
        ble.readCharacteristicValue(pwmConfigCharacteristic.getHandle(), pwmConfig, &bytesRead);
        set_pwm_config(pwmConfig[0]);     
    } else if (charHandle == pwmPeriodCharacteristic.getHandle()) {
        DEBUG("pwmPeriodCharacteristic!\n\r");
        uint32_t    l;
        uint16_t bytesRead;
        ble.readCharacteristicValue(pwmPeriodCharacteristic.getHandle(), pwmPeriod, &bytesRead);
        int i=pwmPeriod[0];
        l =((uint32_t)pwmPeriod[1])<<24;
        l|=((uint32_t)pwmPeriod[2])<<16;
        l|=((uint32_t)pwmPeriod[3])<< 8;
        l|=((uint32_t)pwmPeriod[4])<< 0;
        if(i<3){
            pwmPeriod[i]=l;
            set_pwm_period(i);
        }
    } else if (charHandle == pwmDutyCharacteristic.getHandle()) {
        DEBUG("pwmDutyCharacteristic!\n\r");
        uint32_t    l;
        uint16_t bytesRead;
        ble.readCharacteristicValue(pwmDutyCharacteristic.getHandle(), pwmDuty, &bytesRead);
        int i=pwmDuty[0];
        l =((uint32_t)pwmDuty[1])<<24;
        l|=((uint32_t)pwmDuty[2])<<16;
        l|=((uint32_t)pwmDuty[3])<< 8;
        l|=((uint32_t)pwmDuty[4])<< 0;
        if(i<3){
            pwm_duty[i]=l;
            set_pwm_duty(i);
        }
/*    } else if (charHandle == analogDriveCharacteristic.getHandle()) {
        DEBUG("analogDriveCharacteristic!\n\r");
    } else if (charHandle == i2cConfigCharacteristic.getHandle()) {
        DEBUG("i2cConfigCharacteristic!\n\r");
    } else if (charHandle == i2cStartStopCharacteristic.getHandle()) {
        DEBUG("pioSettingCharacteristic!\n\r");
    } else if (charHandle == i2cWriteCharacteristic.getHandle()) {
        DEBUG("i2cStartStopCharacteristic!\n\r");
    } else if (charHandle == i2cReadParamCharacteristic.getHandle()) {
        DEBUG("i2cReadParamCharacteristic!\n\r");
    } else if (charHandle == uartConfigCharacteristic.getHandle()) {
        DEBUG("uartConfigCharacteristic!\n\r");
    } else if (charHandle == uartBaudrateCharacteristic.getHandle()) {
        DEBUG("uartBaudrateCharacteristic!\n\r");
    } else if (charHandle == uartTxCharacteristic.getHandle()) {
        DEBUG("uartTxCharacteristic!\n\r");
        uint16_t bytesRead;
        ble.readCharacteristicValue(uartTxCharacteristic.getHandle(), uartTx, &bytesRead);
        DEBUG("ECHO: %s\n\r", (char *)uartTx);
//      pc.putc(uartTx[0]);
        ble.updateCharacteristicValue(uartRxCharacteristic.getHandle(), uartTx, bytesRead);
    } else if (charHandle == hardwareRestCharacteristic.getHandle()) {
        DEBUG("hardwareRestCharacteristic!\n\r");*/
    }     
}

void periodicCallback(void)
{
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */
    if (ble.getGapState().connected) {
        /* Update the battery measurement */
        batteryLevel--;
        if (batteryLevel == 1) {
            batteryLevel = 100;
        }
//        ble.updateCharacteristicValue(batteryPercentage.getHandle(), &batteryLevel, sizeof(batteryLevel));
//        ble.updateCharacteristicValue(hardwareLowBatCharacteristic.getHandle(), &batteryLevel, sizeof(batteryLevel));
/*        if(pc.readable()) {
            char data;
            data = pc.getc();
            ble.updateCharacteristicValue(uartRxCharacteristic.getHandle(), (uint8_t*)&data, 1);
        }*/
    }
}

int main(void)
{
    led1 = 1;
    led2 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);

    DEBUG("Initialising the nRF51822\n\r");
    ble.init();
    ble.onConnection(connectionCallback);
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWritten);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);

    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();

//    ble.addService(batteryService);
    ble.addService(informationService);
//    ble.addService(konashiService1);
    ble.addService(konashiService);

    while (true) {
        ble.waitForEvent();
    }
}
