#include "mbed.h"
#include "Adafruit_MotorShield.h"
#include "Adafruit_PWMServoDriver.h"

Serial pc(USBTX,USBRX);

// Create the motor shield object with the default I2C address
//Adafruit_MotorShield AFMS = Adafruit_MotorShield(p9, p10, 0x60 << 1); 
Adafruit_MotorShield AFMS = Adafruit_MotorShield(D14, D15, 0x60 << 1); 
// Or, create it with a different I2C address (say for stacking)
// Adafruit_MotorShield AFMS = Adafruit_MotorShield(0x61); 

// Select which 'port' M1, M2, M3 or M4. In this case, M1
Adafruit_DCMotor *myMotor = AFMS.getMotor(1);
// You can also make another motor on port M2
//Adafruit_DCMotor *myOtherMotor = AFMS.getMotor(2);

void setup() {
  pc.baud(9600);           // set up Serial library at 9600 bps
  pc.printf("Adafruit Motorshield v2 - DC Motor test!\n\r");

  AFMS.begin();  // create with the default frequency 1.6KHz
  //AFMS.begin(1000);  // OR with a different frequency, say 1KHz
  
  // Set the speed to start, from 0 (off) to 255 (max speed)
  myMotor->setSpeed(150);
  myMotor->run(FORWARD);
  // turn on motor
  myMotor->run(RELEASE);
}

void loop() {
  uint8_t i;
  
  pc.printf("tick\n\r");

  myMotor->run(FORWARD);
  for (i=0; i<255; i++) {
    myMotor->setSpeed(i);  
    wait_ms(10);
  }
  for (i=255; i!=0; i--) {
    myMotor->setSpeed(i);  
    wait_ms(10);
  }
  
  pc.printf("tock\n\r");

  myMotor->run(BACKWARD);
  for (i=0; i<255; i++) {
    myMotor->setSpeed(i);  
    wait_ms(10);
  }
  for (i=255; i!=0; i--) {
    myMotor->setSpeed(i);  
    wait_ms(10);
  }

  pc.printf("tech\n\r");
  myMotor->run(RELEASE);
  wait(1.0);
}

int main() {
    setup();
    while(1) {
        loop();
    }
}