/*
 * This content is released under the (https://opensource.org/licenses/MIT) MIT License.
 *
 * Simple code to upload temperature readings to SensorUp SensorThings Playground (http://pg.sensorup.com)
 * from the XBee moudle.
 * It works with mbed LPC1768. (https://developer.mbed.org/platforms/mbed-LPC1768/)
 */
#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "TinyHTTP.h"
#include "LM75B.h"
#include "C12832.h"

/*
* Change the DATASTREAM_ID_TEMP to the id of you SensorThigns Datastream.
* You can get the Datastream <id> from the SensorUp playground's Observation
* API Request:/st-playground/proxy/v1.0/Datastreams(<id>)/Observations
*/
const int DATASTREAM_ID_TEMP = 155384;
/*
* Change the ACCESS_TOKEN to the token of you SensorThigns Datastream
* You can get the ACCESS_TOKEN from the SensorUp playground's Observation 
* API Request: St-P-Access-Token: 2c0fd43e-8471-4139-a86b-be5e32d7d732
*/
const char *ACCESS_TOKEN = "2c0fd43e-8471-4139-a86b-be5e32d7d732";
/*
* Interval(second) to post temperature
*/
const int INTERVAL  = 5;
//Ethernet network interface
EthernetNetIf eth;
//LCD
C12832 lcd(p5, p7, p6, p8, p11);
Serial xbee1(p9, p10); 
DigitalOut rst1(p30); 

const char *HOSTNAME = "pg-api.sensorup.com";
const char *DATASTREAM_URL = "/st-playground/proxy/v1.0/Datastreams(%d)/Observations";

int postToServer(float temp)
{
    Host host;
	char msg[50],uri[100], head[160];
	// header
	snprintf(head, sizeof(head), "Content-type: application/json\r\nSt-P-Access-Token: %s\r\n", ACCESS_TOKEN);
	// uri
	snprintf(uri, sizeof(uri), DATASTREAM_URL, DATASTREAM_ID_TEMP);
	// msg
	snprintf(msg, sizeof(msg), "{\"result\":%.3f\n}", temp);

	host.setName(HOSTNAME);
	host.setPort(HTTP_PORT);
	return httpRequest(METHOD_POST, &host, uri, head, msg);
}

int main () {
    EthernetErr ethErr;
    Host host;
    int r;
    rst1 = 0; //Set reset pin to 0 
    wait_ms(1); 
    rst1 = 1; //Set reset pin to 1 
    wait_ms(1); 
    float sensor; 
    
	// Start the Ethernet connection
    ethErr = eth.setup();
    if(ethErr) {
        printf("connect error\r\n");
        return -1;
    }
	printf("start\r\n");

    while (1) {
	    if(xbee1.readable()){ 
	        lcd.cls();
            lcd.locate(0,3);
	        wait(1);  
	        xbee1.scanf("%f", &sensor); 
	        if(sensor < 50 && sensor > -20) {
	            lcd.printf("reading %.3f\n", sensor);
		        r = postToServer(sensor);
		        wait(INTERVAL);
	        }
      }
    }
}