/*
    + Este programa funciona con el modem GSM en un celular SIEMENS A56i.
    + Reconoce el mensaje 'Voltaje' y devuelve un mensaje a un numero 
      especificado el voltaje sensado en PTB0 (ADC).
    + Reconoce el mensaje 'Pwm####' siendo #### un valor entre 0000 y 1000 y 
      activa la salida PWM PTE20 con su ciclo de dureza en este rango.
    + El conector se distingue asi:
      - Cable verde es RX conectelo a PTE0. 
      - Cable blanco es TX conectelo a PTE1.
      
    + Realizado por: Carolina Velez Castaño
                     Daniel Sebastian Múnera Toro
                     Robinson Sneider Álvarez Valle
                  
    + Universidad Nacional de Colombia sede Medellín      
*/

#include "mbed.h"
#include "stdio.h"
#include "string.h"
#include <math.h>

int i,ret;
int K,C,LENOUT,LENIN,LENOUT1, LENIN1, LENOUT2, LENIN2, ind;
Timer t;

DigitalOut LedRojo(LED1,1);
DigitalOut LedVerde(LED2,1);
DigitalOut LedAzul(LED3,1);

Serial GSM(PTE0,PTE1); //Configura puerto UART de la FRDMKL25Z
Serial pc(USBTX,USBRX);//Configura puerto USB a la consola serial del PC conectado.

AnalogIn input0(PTB0);
PwmOut pwm0(PTE20);

char msg[15];
char msg0[13];
char msg1[7];
char msg2[9];
char analogStr[20];
char gs[20];
char input0_char[10];

char DE1[255];
char DS1[255];
char DE2[255];
char DS2[255];
char buffer[512];
char resp[6];
char tam[2];
char mensaje[100];
char buf[100];

char tel[10] = {'0','3','3','5','4','5','2','1','5','8'};
char relle1[10] = {'0','0','1','1','0','0','0','A','9','1'};
char relle2[6] = {'0','0','0','0','A','A'};
char message[] = "0011000A9103354521580000AA03";
    
//******************************FUNCIONES EN C**********************************

/*******************************************************************************
                      Funciones para el formato PDU
*******************************************************************************/

/*******************************************************************************
    Lee todo un bufer hasta encontrar CR o LF y el resto lo rellena de '$',
    count es lo que va a leer; Lo leido lo mete en buffer que es una cadena 
    previamente definida incorpora medida de tiempo si se demora mas de tres 
    segundos retorna fracaso con -1
*******************************************************************************/ 
int readBuffer(char *buffer,int count){
    int i=0; 
    t.start();  // start timer
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
        if(i > count)break;
        if(t.read() > 5) {
            t.stop();
            t.reset();
            break;
        }
    }
    wait(0.5);
    while(GSM.readable()) {  // display the other thing..
        char c = GSM.getc();
    }
    return 0;
}


/*******************************************************************************
    Limpia o borra todo un "buffer" de tamaño "count" lo revisa elemento por 
    elemento y le mete el caracter null que indica fin de cadena no retorna nada
*******************************************************************************/
void cleanBuffer(char *buffer, int count){
    for(int i=0; i < count; i++) {
        buffer[i] = 0;
    }
}

/*******************************************************************************
    Envia un comando parametrizado como cadena puede ser un comando tipo AT
*******************************************************************************/
void sendCmd(char *cmd){
    GSM.puts(cmd);
}

/*******************************************************************************
    Espera la respuesta de un comando que debe ser identica a la cadena "resp" y
    un tiempo 'timeout' si todo sale bien retorna un cero que en la programacion 
    hay que validar si algo sale mal (no se parece o se demora mucho) retorna -1 
    que debera validarse con alguna expresion logica
*******************************************************************************/
int waitForResp(char *resp, int timeout){
    int len = strlen(resp);
    int sum=0;
    t.start();

    while(1) {
        if(GSM.readable()) {
            char c = GSM.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;// esta linea de C# sum se incrementa o se hace cero segun c
            if(sum == len)break;  //ya acabo se sale
        }
        if(t.read() > timeout) {  // time out chequea el tiempo minimo antes de salir perdiendo
            t.stop();
            t.reset();
            return -1;
        }
    }
    t.stop();                 // stop timer  antes de retornar
    t.reset();                    // clear timer
    while(GSM.readable()) {      // display the other thing..
        char c = GSM.getc();
    }

    return 0;
}

/*******************************************************************************
    Se encarga de enviar el comando y esperar la respuesta si todo sale bien 
    retorna un cero(herencia de las funciones contenedoras) que en la 
    programacion hay que validar con alguna expresion logica
*******************************************************************************/
int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout){
    sendCmd(cmd);
    return waitForResp(resp,timeout);
}

/*******************************************************************************
    Chequea que el modem este vivo envia AT y le contesta con OK y espera 2 
    segundos
*******************************************************************************/
int powerCheck(void){
    return sendCmdAndWaitForResp("AT\r\n", "OK", 2);    
}

/*******************************************************************************
    Chequea el estado de la sim card y si todo sale bien retorna un cero que en 
    la programacion hay que validar con alguna expresion logica
*******************************************************************************/
int checkSIMStatus(void){
    char gprsBuffer[30];
    int count = 0;
    cleanBuffer(gprsBuffer,30);
    while(count < 3) {
        sendCmd("AT+CPIN?\r\n");
        readBuffer(gprsBuffer,30);
        if((NULL != strstr(gprsBuffer,"+CPIN: READY"))) {
            break;
        }
        count++;
        wait(1);
    }

    if(count == 3) {
        return -1;
    }
    return 0;
}

/*******************************************************************************
    Chequea la calidad de la señal y si todo sale bien retorna con el valor de 
    señal util o un -1 si no es aceptable, en la programacion hay que validar
    con alguna expresion logica
*******************************************************************************/
int checkSignalStrength(void){
    char gprsBuffer[100];
    int index,count = 0;
    cleanBuffer(gprsBuffer,100);
    while(count < 3) {
        sendCmd("AT+CSQ\r\n");
        readBuffer(gprsBuffer,25);
        if(sscanf(gprsBuffer, "AT+CSQ$$$$+CSQ: %d", &index)>0) {
            break;
        }
        count++;
        wait(1);
    }
    if(count == 3) {
        return -1;
    }
    return index;
}

/*******************************************************************************
    Inicializa el modem
*******************************************************************************/
int init(){
    if (0 != sendCmdAndWaitForResp("AT\r\n", "OK", 5)){
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CNMI=1,1\r\n", "OK", 5)){
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CMGF=0\r\n", "OK", 5)){
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CBST=0,0,1\r\n", "OK", 5)){
        return -1;
    }
    return 0;
}


/*******************************************************************************
                Funciones para el manejo de las cadenas
*******************************************************************************/

/*******************************************************************************
    Pasa de septetos a octetos    
*******************************************************************************/
void SepToOct(char *DE, char *DS){
    LENIN = strlen(DE);   // Se mide el tamaño de la cadena de entrada
    int K=0;int C=0; int i=0;
    for (i=0;i < LENIN;i++){
        DS[i]=DE[i+C]>>K | DE[i+C+1]<<(7-K);
        if (DS[i]==0x00) {LENOUT=i; goto salir99;}  // Fin de la transformacion
        K++;
        if (K==7) {K=0;C++;}    // Se chequea que ya se acabaron los bits en un ciclo de conversion.
    }
    salir99:
        for (i=0;i<LENOUT;i++){
            DS[i]=DS[i]&0x000000FF;
        }
    return;
}

/*******************************************************************************
    Pasa de octetos a septetos
*******************************************************************************/
void OctToSep(char *DE, char *DS){
     int LENIN = strlen(DE);    
     int LENOUT = LENIN*8/7;
     K = 7;
     C = 0;
     DS[0] = DE[0] & 0x7F;  // la primera sola
     for (i=1;i < LENOUT;i++){  // inicia el algoritmo
         DS[i]=(DE[i-1-C]>>K | DE[i-C]<<(8-K))& 0x7F;  //valido para todos
         if (K==0) {K=8;C++;}
         K--;
     }
     return;        
 }

//*****************SE INICIA EL PROGRAMA PRINCIPAL******************************
int main(){
    LedRojo = 0;
    LedVerde = 1;
    LedAzul = 1;
    
    pwm0 = 0;
        
    //****************CONFIGURAMOS EL MODEM GSM (TELEFONO CELULAR SIEMENS A56i)
    inicio1:        
        ret = init();
        if(ret==0){
            LedRojo = 1;
            LedVerde = 0;
            LedAzul = 1;
        }
        else{
            wait(5);
            goto inicio1;    
        }
        
    while(1){
        // Inicia la recepcion de un mensaje de texto        
        if (GSM.readable()){
            readBuffer(buffer,6);
            pc.printf("%s\r\n",buffer);
            for(i=0;i<5;i++){
                resp[i]=buffer[i];
            }  
            pc.printf("%s\r\n",resp);
            if(strcmp("$$+CM",resp) == 0){  // Compara respuesta con "+CMTI"
                pc.printf("Llego MSG\r\n");
                cleanBuffer(buffer,6);
                GSM.printf("AT+CMGL=0");    // Envio comando para leer mensaje
                GSM.putc(0x0D);             // Envio de caracterer \n
                pc.printf("AT+CMGL=0\r\n");
                loop1:
                if (GSM.readable()){
                    readBuffer(buffer,100);
                    pc.printf("%s\r\n",buffer);
                    goto seguir1;
                }
                goto loop1;
                seguir1:
                //leer telefono
                for(i=0;i<10;i++){
                    tel[i]=buffer[i+50];
                }
                pc.printf("%s-\r\n",tel);
                     
                // Leer tamaño
                for(i=0;i<2;i++){
                    tam[i]=buffer[i+78];
                }
                pc.printf("%s-\r\n",tam);        
                
                // Leer mensaje
                for(i=0;i<14;i++){
                    msg[i]=buffer[i+80];
                }
                pc.printf("%s-\r\n",msg);
                
                // Dividir mensaje, facilita comparación de tramas
                for(i=0;i<12;i++){          // Solo guarda 12 posiciones del  
                    msg0[i]=buffer[i+80];;  // mensaje porque los ultimos dos 
                }                           // caracteres pueden dañar la 
                pc.printf("%s-\r\n",msg0);  // comparación por los cambios del
                                            // operador.
                for(i=0;i<6;i++){
                    msg1[i]=buffer[i+80];;
                }
                pc.printf("%s-\r\n",msg1);
                for(i=0;i<8;i++){
                    msg2[i]=buffer[i+86];;
                }
                pc.printf("%s-\r\n",msg2);
                
                GSM.printf("AT+CMGD=0");    // Envio comando para borrar mensaje
                GSM.putc(0x0D);             // Envio de caracter \n
                wait(1);
                GSM.printf("AT+CMGD=1");    // Envio comando para borrar mensaje
                GSM.putc(0x0D);             // Envio de caracter \n
                wait(1);
      
                // Comparar mensaje
                /*
                Cadenas compara 'Voltaje'
                    D6379B1E569701
                    D6379B1E56971B
                */
                if(strcmp("D6379B1E5697",msg0) == 0){  // Compara con "Voltaje"
                    LedRojo = 1;
                    LedVerde = 1;
                    LedAzul = 0;
                    
                    sprintf(input0_char,"%.2f",input0.read()*3.3);
                    cleanBuffer(gs,20);
                    SepToOct(input0_char,gs);
                    //pc.printf("%s\n",input0_char);
                    
                    // Envio del mensaje
                    GSM.printf("AT+CMGS=16\n\r");
                    wait_ms(200);
                    GSM.printf(message);                    // Imprime cabecera
                    for (i=0;i<3;i++){
                        GSM.printf("%2X",gs[i]&0x000000FF); // Imprime conversión
                    }
                    wait_ms(200);
                    GSM.putc((char)0x1A);
                    wait(10);
                    
                    ///si el operador contesta con mensaje borrar de nuevo
                    GSM.printf("AT+CMGD=0");//envio comando para borrar mensaje
                    GSM.putc(0x0D);         //envio de caracter \n
                    wait(1);
                    GSM.printf("AT+CMGD=1");//envio comando para borrar mensaje
                    GSM.putc(0x0D);         //envio de caracter \n
                    wait(1);
                                        
                    //wait(5);
                    LedRojo = 1;
                    LedVerde = 0;
                    LedAzul = 1;
                }
                
                /*
                Cadenas compara 'Pwm000'
                    D07B1B0683C100
                    D07B1B0683C11A
                */
                if(strcmp("D07B1B",msg1) == 0){  // Compara con "Pwm"
                    cleanBuffer(gs,20);
                    OctToSep(msg2,gs);
                    
                    pwm0 = gs[0]/100.0;
                    
                    LedRojo = 1; LedVerde = 1; LedAzul = 0;
                    wait(1);
                    LedRojo = 1; LedVerde = 1; LedAzul = 1;
                    wait(1);
                    LedRojo = 1; LedVerde = 1; LedAzul = 0;
                    wait(1);
                    LedRojo = 1; LedVerde = 1; LedAzul = 1;
                    wait(1);
                    LedRojo = 1; LedVerde = 1; LedAzul = 0;
                    wait(1);
                    LedRojo = 1; LedVerde = 1; LedAzul = 1;
                    wait(1);
                    LedRojo = 1; LedVerde = 1; LedAzul = 0;
                    wait(1);
                    LedRojo = 1; LedVerde = 1; LedAzul = 1;
                    wait(1);
                    LedRojo = 1; LedVerde = 1; LedAzul = 0;
                    wait(1);
                    LedRojo = 1; LedVerde = 0; LedAzul = 1;
                }
                    
                if(strcmp("D07B3B",msg1) == 0){  // Compara con "Pwm1000"
                    pwm0 = 1;
                                     
                    LedRojo = 1; LedVerde = 1; LedAzul = 0;
                    wait(.5);
                    LedRojo = 1; LedVerde = 1; LedAzul = 1;
                    wait(.5);
                    LedRojo = 1; LedVerde = 1; LedAzul = 0;
                    wait(.5);
                    LedRojo = 1; LedVerde = 1; LedAzul = 1;
                    wait(.5);
                    LedRojo = 1; LedVerde = 1; LedAzul = 0;
                    wait(.5);
                    LedRojo = 1; LedVerde = 1; LedAzul = 1;
                    wait(.5);
                    LedRojo = 1; LedVerde = 1; LedAzul = 0;
                    wait(.5);
                    LedRojo = 1; LedVerde = 1; LedAzul = 1;
                    wait(.5);
                    LedRojo = 1; LedVerde = 1; LedAzul = 0;
                    wait(.5);
                    LedRojo = 1; LedVerde = 0; LedAzul = 1;                    
                }
                
                cleanBuffer(buffer,100);      
            }
        }
    }        
}