#include "mbed.h"
#include "WiflyInterface.h"
#include <string.h>
DigitalOut SetalarmOn(p26);
Serial pc(USBTX, USBRX);
#define On 0
#define Off 1 

/* creation de l'instance wifly
-
sécurité : WPA
-
SSID : vega
-
mt de passe : btssnvega
Attention au sens des broches : TX RX
Reset Status */
WiflyInterface wifly(p9, p10, p12, p11, "vega", "btssnvega", WPA);
//WiflyInterface wifly(p9, p10, p30, p29, "nom", "MDP", NONE);
TCPSocketServer server;
TCPSocketConnection client;
int serveur_port = 2000;
unsigned int NbcaracRecu = 0;
int main()
{
    bool client_connected = false;
    bool client_open = false;
    char buffer [100];
    pc.printf("Hello, I'm happy my Virtual Serial port is ok.\n\r");
    pc.printf("Init WIfi.\n\r");
     if (wifly.init("192.168.0.20","255.255.255.0","192.168.0.254")!=0) { //Innitialise interface ici dhcp
        pc.printf("ERREUR INIT ETHERNET\r\n");
        return-1;
    }
    pc.printf("Init Wifi ok.\n\rConnect Wifly.\n\r");
    if (!wifly.connect()) { // Connecte interface
        pc.printf("Tests en erreur, ERREUR Connect, quitte programme\r\n");
        return-1;
//       }
    }
    pc.printf("Ip sur Wifly is Ok.\n\r");
    printf("IP Address is %s\r\n",wifly.getIPAddress());
    pc.printf("\r\nVous devez maintenant installer Tcp.\n\r");
    if (server.bind (serveur_port)!=0) {
        pc.printf("Erreur Tcp bind\r\n");
        return-1;
    }
    pc.printf("Succes Tcp Bind\r\n");
    if (server.listen()!=0) {
        pc.printf("ERREUR Tcp Listen\r\n");
        return-1;
    }
    pc.printf("Succes Tcp listen\r\n");
    pc.printf("Connectez un client Tcp port %u...\r\n",serveur_port);
    client.set_blocking(false, 1); // Timeout after (100ms)
    while(1) {
        if (client_connected==false) {
            if (server.accept (client)!=0) {
                pc.printf("ERREUR connexion client\r\n"); // erreur
                return -1;
            }
            client_open = false;
            client_connected = true;
            pc.printf("Client Tcp connecte\r\n");
            NbcaracRecu = 0;
        } else {
            if ( client.is_connected() ) {
                if (pc.readable()) { // interface virtuel serie recoit donnees
                    buffer[0] = pc.getc();
                    client.send(buffer,1);
                }
// lecture message
                int nbcaractere = client.receive(buffer+NbcaracRecu,sizeof(buffer)-NbcaracRecu);
                if (nbcaractere>0) { // interface Wifi recoit donnees
                    NbcaracRecu = NbcaracRecu + nbcaractere;
                    buffer[NbcaracRecu] = 0;
// pour debug
                    pc.printf("Jai recu ce jour : Totrecu = %u recu = %u phrase : %s\r\n Code Ascii : ",NbcaracRecu,nbcaractere,buffer);
                    for (unsigned i = 0; i <NbcaracRecu; i++) {
                        pc.printf("%u,",buffer[i]);
                    }
                    pc.printf("\r\n");

// si dernier octet est 10 alors message complet

                    if (buffer[NbcaracRecu-1] == 10)  {

                        buffer[NbcaracRecu-2] = 0;   // on met 0 en fin de message en retirant \r\n

// pour afficher pour verifier en debug
                        for (unsigned i = 0; i <NbcaracRecu; i++) {
                            pc.printf("%u,",buffer[i]);
                        }
                        pc.printf("\r\n");
                        pc.printf("\r\n---------------------------------\r\n");
                        pc.printf("Phrase complete : %s\r\n",buffer);
// jusque la ...


// on interprete les messages
                        if (client_open == false) {
                            if (strcmp(buffer,"connect;")==0) {
                                pc.printf("Commande reconnue On\r\n");
                                client.send("on\n\r",strlen("on\n\r"));
                                client_open = true;
                            } else {
                                client_connected = false;
                                client.close();
                                pc.printf("Client deconnecte\r\n");
                                pc.printf("Connectez un client Tcp port 2000...\r\n");
                            }
                        } else 
                        if (strcmp(buffer,"on;")==0) {
                            pc.printf("Commande reconnue On\r\n");
                            client.send("on\n\r",strlen("on\n\r"));
                            SetalarmOn = On;
                            }
                        else if (strcmp(buffer,"off;")==0) {
                            pc.printf("Commande reconnue Off\r\n");
                            client.send("off\n\r",strlen("off\n\r"));
                            SetalarmOn = Off;
                            }
                        else pc.printf("Commande inconnu\r\n");
                        
                        NbcaracRecu = 0;

                    }
                }
            } else {
                client_connected = false;
                client_open = false;
                client.close();
                pc.printf("Client deconnecte\r\n");
                pc.printf("Connectez un client Tcp port 2000...\r\n");
            }
        }
    }
}