#ifndef CORE_H
#define CORE_H
#include "mbed.h"
#define B_RIGHT 0xE0
#define B_LEFT   0x70
#define B_UP      0xD0
#define B_DOWN 0xB0
#define B_ERASE 0x60
int GetTicker();
class JetiC { // free-wheeling communication with the JetiBox
	/* use :
	constructor initialize a first message
	loop until isAnswer()==True
		process the answer : select() + display()
		getSensor()
		
	*/
	public:
	JetiC(); 
	bool isAnswer(); //-> true after the Get from Rx ; reset  when the call isAnswer() returned true
	int current_node;
	int buttons; //answer from the jei box buttons
	//void write_buffer();
	void display(); //format the buffer for the current node and the current sensor data
    void select( ); // process the answer to select a new current_node
	void debug_display();
	//-----various utility functions to fill the buffer-------------------------------
	void clear();
	void print(char);
	void print(long value, uint8_t len); // len = total length
	void printf(float value, uint8_t decimals, uint8_t len); // 2nd argument = number of decimals
	void print_p(const char *); //const char * const mystrings[] = {"aaa","zzzz"};
	void setPos(int);//set the position of the "cursor"
	
	private:
	
	//Timer loop;
	void printNumber( int value, uint8_t pos, uint8_t len);
	int pos;
	int mode; //0 = normal message 1=special sequence to quit the sensor going left through the expander

//this class is in the file JetiC.cpp, with the interrupt routines and their specific data
};

// common data
struct instr_data{
	JetiC*    jetiptr; //pointer to the JetiBox object..or NULL
//	Sensor* sensorptr ; // pointer to the Sensor Object
	
};
#endif

