/**
 * Test program for a bug. (http://mbed.org/forum/bugs-suggestions/topic/1074/)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "mbed.h"
#include "Semaphore.h"

Serial ser(USBTX, USBRX);

DigitalOut interrupt_data_led(LED1);
DigitalOut dataled(LED2);
DigitalOut data_locked_led(LED3);
DigitalOut no_data_led(LED4);

Semaphore sem;

volatile char shared_resource = 'a';   // This is a shared resource for example.

#define LOCK() sem.try_enter()
#define UNLOCK() sem.release()

void toggle_led( DigitalOut &led) {
    if ( 1 == led)
        led = 0;
    else
        led = 1;
}

char* my_itoa(int val, int base) {
    static char buf[12] = {0};

    int i = 10;
    if ( 0 != val) {
        for (; val && i ; --i, val /= base)
            buf[i] = "0123456789abcdef"[val % base];
        return &buf[i+1];
    } else {
        buf[0] = '0';
        buf[1] = '0';
        return &buf[0];
    }
}

void waitBeforeSend(char ch) {
    while ( 0 == ser.writeable()) {
        wait_ms(1);
    }
    ser.putc( ch );
    toggle_led(dataled);
}


/**
 * A call back function for serial interrupt.
 */
void func_serial_interrupt(void) {
    toggle_led(interrupt_data_led);
    if (LOCK()) {
        shared_resource = ser.getc();
        UNLOCK();
    } else {
        toggle_led(no_data_led);
    }
}

/**
 * Entry point.
 */
int main() {
    int i = 0;
    char *out = "my semaphore test program\r\n";
    ser.attach(&func_serial_interrupt);
    char *ptr = out;
    while ( *ptr != 0 ) {
        waitBeforeSend(*ptr);
        ptr++;
    }

    while (1) {
        /*
         * Hung up serial communication if you hit keys on console for Serial.
         */
        if (LOCK()) {
            ptr = my_itoa(shared_resource, 16);
            UNLOCK();
            while ( *ptr != 0 ) {
                waitBeforeSend(*ptr);
                ptr++;
            }
            i++;
            i %= 20;
            if (!i) {
                waitBeforeSend('\r');
                waitBeforeSend('\n');
            } else {
                waitBeforeSend(' ');
            }
        } else {
            toggle_led(data_locked_led);
        }
        wait_ms(100);
    }
}
