#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

#define ScreenWidth 32
#define ScreenHeight 15

#define HTTPChunkSize 1024

#define ScreenBufferSize ScreenWidth*ScreenHeight*3

typedef struct {
  byte blue;
  byte green;
  byte red;
} color;

unsigned int fileFrameCount;

color disp[ScreenWidth][ScreenHeight];
byte screenBuf[ScreenBufferSize];
byte readBuf[HTTPChunkSize];

Serial pc(USBTX, USBRX);

SPI spi(p5, NC, p7); // mosi, miso, sclk

#define LEDCount 110
#define channels LEDCount*3

EthernetNetIf eth; 
HTTPClient http;

HTTPResult result;
bool completed = false;

void request_callback(HTTPResult r)
{
    result = r;
    completed = true;
}


void writePixel(int x, int y) {

    spi.write(screenBuf[(x*ScreenHeight+y)*3]);
    spi.write(screenBuf[(x*ScreenHeight+y)*3+1]);
    spi.write(screenBuf[(x*ScreenHeight+y)*3+2]);

}


void updateDisplay() {
    for (int y = ScreenHeight-1; y >= 0; y--) {
        if (y % 2 == 0) {
            for (int x = 0; x < ScreenWidth; x++) 
                writePixel(x,y);
        } 
        else {
            for (int x = ScreenWidth-1; x >= 0; x--)
                writePixel(x,y);
        }
    }
    wait_us(800);
}

 

void hexDump(byte *buf, unsigned long len, int wid) {

    for (unsigned long i = 0; i < len; i++) {
        if (!(i % wid)) pc.printf("\n");
        else if (!(i % 4)) pc.printf(" ");

        pc.printf("%02x", buf[i]);
    }
    pc.printf("\n");
}
      

int setupEthernet() {

    pc.printf("Start\n");

    pc.printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
     
    if(ethErr) {
        pc.printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    pc.printf("Setup OK\n");
    return (0);
}


int main() {

    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,1);
    spi.frequency(1000000);
    
    pc.baud(115200);
    
    setupEthernet();
    HTTPStream stream;
    unsigned long dataReadRemaining = 6;
    bool headerLoaded = false;
    unsigned int screenBufInd = 0;
    
    stream.readNext((byte *)readBuf, 6);
    
    HTTPResult r = http.get("http://192.168.1.129/traffic.vid", &stream, request_callback);
     
    while(!completed) {
        Net::poll(); //Polls the Networking stack
        
        if (stream.readable()) {
            unsigned int readLength = stream.readLen();
            
            // Load and process six byte header
            // Three integers -- frame count, height, width            
            if (headerLoaded == false) {
                headerLoaded = true;
                fileFrameCount = readBuf[0]+readBuf[1]*256;
                pc.printf("# of frames: %i\n", fileFrameCount);
                pc.printf("height x width: %i x %i\n", readBuf[2]+readBuf[3]*256, readBuf[4]+readBuf[5]*256);
                
                dataReadRemaining = ScreenBufferSize;
                stream.readNext(readBuf, HTTPChunkSize);
            }
            // else load image
            else {
                dataReadRemaining -= readLength;
                //pc.printf("%i", (unsigned int)dataReadRemaining);
                
                memcpy(screenBuf + screenBufInd, readBuf, readLength);
                
                // if any remaining data
                if (dataReadRemaining) {
                    //pc.printf(".\n");
                    screenBufInd += readLength;
                    stream.readNext((byte*)readBuf, (dataReadRemaining > HTTPChunkSize ? HTTPChunkSize : dataReadRemaining));
                }
                else {
                    //pc.printf("!\n"); 
                
                    // hexDump(screenBuf,1440,32);
                    updateDisplay();
                    //while(1);
                
                    dataReadRemaining = ScreenBufferSize;
                    screenBufInd = 0;
                    stream.readNext((byte*)readBuf, HTTPChunkSize); 
                }
            }
        }
    
    }
    pc.printf("\n--------------\n");
    if (result == HTTP_OK) pc.printf("Read completely\n"); 
    else pc.printf("Error %d\n", result);

  
    while(1){}
}
