/*
 * Echo server
 * Listens on TCP and UDP ports 7 for any incoming connections
 * Re-transmits any incoming bytes
 */

#include "mbed.h"
#include "EthernetNetIf.h"

#include "EchoServer.h"

// Our Ethernet interface
EthernetNetIf eth;
// Our Echo server
EchoServer server;

#define byte char

#define ScreenWidth 32
#define ScreenHeight 15

#define HTTPChunkSize 1024

#define ScreenBufferSize ScreenWidth*ScreenHeight*3

bool drawReadyFlag = false;

typedef struct {
  byte blue;
  byte green;
  byte red;
} color;

unsigned int fileFrameCount;

byte screenBuf[ScreenBufferSize];

Serial pc(USBTX, USBRX);

SPI spi(p5, NC, p7); // mosi, miso, sclk

void writePixel(int x, int y) {

    spi.write(screenBuf[(x*ScreenHeight+y)*3]);
    spi.write(screenBuf[(x*ScreenHeight+y)*3+1]);
    spi.write(screenBuf[(x*ScreenHeight+y)*3+2]);

}


void updateDisplay() {
    for (int y = ScreenHeight-1; y >= 0; y--) {
        if (y % 2 == 0) {
            for (int x = 0; x < ScreenWidth; x++) 
                writePixel(x,y);
        } 
        else {
            for (int x = ScreenWidth-1; x >= 0; x--)
                writePixel(x,y);
        }
    }
    wait_us(800);
}

 

void hexDump(byte *buf, unsigned long len, int wid) {

    for (unsigned long i = 0; i < len; i++) {
        if (!(i % wid)) pc.printf("\n");
        else if (!(i % 4)) pc.printf(" ");

        pc.printf("%02x", buf[i]);
    }
    pc.printf("\n");
}


/*
    Function: main
    
    Sets up the Ethernet interface using DHCP, reports the assigned
    IP address via serial, binds the Echo server to port 7 on
    TCP and UDP and then sits in a loop calling Net::poll() to
    keep the network stack doing its thing
*/
int main() {
    printf("\r\nSetting up...\r\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    IpAddr ip = eth.getIp();
    printf("mbed IP Address is %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]);

    server.bind();

    printf("Entering while loop Net::poll()ing\r\n");
    while (1) {
        Net::poll();
        if (drawReadyFlag) {
            updateDisplay();
            drawReadyFlag = false;
        }
    }
}
