#include "mbed.h"
#include "cc3000.h"
#include "TCPSocketConnection.h"

#pragma once

using namespace mbed_cc3000;

class GloveWifi
{
	public:
		GloveWifi();
		~GloveWifi();
		void Init();
		void Connect();
		void Disconnect();
		void Reconnect();
		int GetDataFromBuffer(char * buf, int size);
		uint8_t SendDataToGlove(uint8_t * buf, uint16_t size);

	private:
    	TCPSocketConnection * socket;
		cc3000 * wifi;
		uint32_t DropCount;
	
};