#include "mbed.h"
#include "WS2811.h"

#pragma once

class LedCube
{
    public:
        LedCube();
        ~LedCube();
        void Init(int x, int y, int z);
        int getLedIndex(int panel, int x, int y);
        void updateLEDs(bool on, int size, int x, int y, int z);
        void updateLEDsOld(bool on, int size, int x, int y, int z);
        void cubeUpdate();
        void UpdateCube(int size, int deltaX, int deltaY, int deltaZ, float hue); 
        int move(int deltaX, int deltaY, int deltaZ);
        void changeColor(float hue);
        void changeSize(int newSize);
        
    private:
        unsigned const X;
        unsigned const Y;
        unsigned const Z;
        int pos[3];
        int prevPos[3];
        int size;
        int prevSize;

        float saturation;
        float brightness;
        uint8_t r;
        uint8_t g;
        uint8_t b;        
        WS2811 ledStrip1;
        WS2811 ledStrip2;
    
};