/*
//alle 20 blauen pins interrupt fähig.
//D0 bis D6, D9 bis D13, A0 bis A7)


    Ticker: LED1 will blink every second
    InterruptIn: LED2 can be toggled through BUTTON1
    Timeout: LED3 will toggle after 2.5 seconds 

BusOut myleds(D0,D3,D6,D9,D11,D12,A1,A5);
*/

#include "mbed.h"

InterruptIn button1(A0);  //A0 oder A3
Ticker t1;
Timeout t2;

DigitalOut led1(D0);
DigitalOut led2(D3);
DigitalOut led3(D6);

DigitalOut ledx(A5);

void blink_led1();
void toggle_led2();
void turn_led3_on();


int main() {
    
    button1.rise(&toggle_led2); //interrupt
    t1.attach(callback(&blink_led1),1.0f); //ticker
    t2.attach(callback(&turn_led3_on),2.5f); //timeout

    
    while(1) 
    {
        ledx = !ledx;
        wait(4); 
    }
}

void turn_led3_on()
{
    led3=!led3;
}

void blink_led1()
{
     led1=!led1;   
}

void toggle_led2()
{
    led2=!led2;
}


