

#include "mbed.h"
#include "SPI_MJERENJE.h"
 
SPI_mjeri::SPI_mjeri(PinName MOSI, PinName MISO, PinName SCL, PinName SS)  // definiranje konstruktora
    :
    spi(MOSI, MISO, SCL),
    ss(SS)  
       

 { inicijalizacija(); // opoziv funkcije za inicijaliziranje
}

void SPI_mjeri::inicijalizacija()       // konstruktor za inicijalizaciju
{
    
    spi.format(8, 0); // 8-bitni podatak, mod 0
    
    spi.frequency(100000); // 100 khhz frekvencija rada
    ss=0;
    spi.write(0xF5); // Registar „config“ postavlja brzinu, filtar i opcije sučelja uređaja.
    spi.write(0b11000000); // Standby 2000ms, bez filtra, 4-zicni SPI sučelje
    spi.write(0xF4); //Registar „ctrl_meas“ postavlja mogućnosti prikupljanja podataka uređaja
     spi.write(0b01100011); // Temparature oversampling x4, Normal mode
    spi.write(0xF3); //Registar „status“ postavlja bitove za indikaciju
     spi.write(0b0);
    ss = 1;
    
    }
 
float SPI_mjeri::izmjeri() //funkcija sa kompenzacijskom formulom iz datasheeta sa stranice 22
{
    
    int32_t temp_raw, var1, var2, temp,t_fine;
    float tempf;
    char dat[3];
    char reg[6];
    
     ss = 0;
    spi.write(0x88); // citanje dig_T registara temperetare 0x88 je adresa LSBa
    for(int i = 0; i < 6; i++)
        reg[i] = spi.write(0); // slanje dummy podataka
    ss = 1;
 
 
    dig_T1 = (reg[1] << 8) | reg[0]; //zapisivanje 8 bitnog podatka u 16 bitova
     dig_T2 = (reg[3] << 8) | reg[2];
      dig_T3 = (reg[5] << 8) | reg[4];
    
    
    
    ss = 0;
    spi.write(0xFA); // adresa registra MSB raw dijela podatka
    for(int i = 0; i < 3; i++)
        dat[i] = spi.write(0);
    ss = 1;
    temp_raw = (dat[0] << 12) | (dat[1] << 4) | (dat[2] >> 4);
    var1 = ((((temp_raw >> 3) - (dig_T1 << 1))) * dig_T2) >> 11;
    var2 = (((((temp_raw >> 4) - dig_T1) * ((temp_raw >> 4) - dig_T1)) >> 12) * dig_T3) >> 14;
    t_fine = var1 + var2;
    temp = (t_fine * 5 + 128) >> 8;
    tempf = (float)temp;
    return (tempf/100.0f);
}
 
 

 
