#include "LCDSEMINAR.h"



LCD::LCD(PinName SDA, PinName SCL ):
i2c(SDA,SCL)

{ inicijalizacija(); // opoziv funkcije za inicijaliziranje
}
 
 
void LCD::inicijalizacija()       // konstruktor za inicijalizaciju
{    i2c.frequency(100000);  // frekvencija rada 100khz
    wait_ms(30);
    naredba(0x01);// ciscenje ekrana
    wait_ms(20);
    naredba(0x3); //inicijalizacijski podaci
    wait_ms(6);
    naredba(0x3);
    wait_ms(6);
    naredba(0x3);
    wait_ms(6);
    naredba(0x2);
    wait_ms(6);
    naredba(0b00101000); //Funtionset 13 str. datasheeta 4bitno sucelje
    naredba(0b00001110); //Display on/off display upaljen pokazivac upaljen blinkanje izgaseno
    }


void LCD::naredba(int byte )
{
    
    char prvidio[2];
    char drugidio[2];
    
    prvidio[0] =  (byte & 0xF0) | 0b1100; // sa stranice https://www.joom.com/en/products/5d78933e8b45130101c739ff podatkovni paket PCF85741 sucelja koje se nalazi na nasem lcdu
    prvidio[1] = (byte & 0xF0) | 0b1000;   // D7, D6, D5, D4, BACKLIGHT , E, R/W , RS 
    i2c.write(0x27<<1,prvidio,2);
    wait_us(200);
    
    drugidio[0] = (byte << 4) | 0b1100;
    drugidio[1] = (byte << 4) | 0b1000;
    i2c.write(0x27<<1,drugidio,2);
    wait_us(200);
    
}


void LCD::print(char podatak)
{
   
    char prvidio[2];
    char drugidio[2];
    
     prvidio[0] =  (podatak & 0xF0) | 0b1101;
     prvidio[1] = (podatak & 0xF0) | 0b1001;
     i2c.write(0x27<<1,prvidio,2);
     wait_us(200);

    

    
    drugidio[0] = (podatak << 4) | 0b1101;
    drugidio[1] = (podatak << 4) | 0b1001;
    i2c.write(0x27<<1,drugidio,2);
    wait_us(200);
   
}
void LCD::ispis (string podatak)
{
    int i=0;
    while(podatak[i]!='\0')
    {
        print(podatak[i++]);
    }
}

void LCD::ocisti()
{
    naredba(0b01); //naredba za ciscenje ekrana
    wait_ms(50);
    pokazivac(0,0);
}
 

void LCD::pokazivac (int stupac, int red)
{
    int adr;
    
    if(red==0) {
    adr= 0x80 + stupac;
       }
    else {
    adr = 0xC0 + stupac;
        }
    naredba(adr);
    
}

