#include "mbed.h"
#include "FXOS8700Q.h"
#include "eCompass_Lib.h"
#include "rtos.h"
//#include "MotionSensorDtypes.h"
#include "EthernetInterface.h"


FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);
FXOS8700Q_mag mag( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);
Serial pc(USBTX, USBRX);
eCompass compass;
DigitalOut red(LED_RED);        //debug led
DigitalOut green(LED_GREEN);    //debug ledeCompass compass;

//void calibrate_thread(void const *argument);
//void print_thread(void const *argument);
//void compass_thread(void const *argument);

extern axis6_t axis6;
extern uint32_t seconds;
extern uint32_t compass_type; // optional, NED compass is default
extern int32_t tcount;
extern uint8_t cdebug;
int  l = 0;
volatile int sflag = 0;

char http_cmd[500];
char devid[] = "1100227";
char api_key[] ="Jl4VyAUUG6j4Qdms3ZyOjbAu6J8=";
char host[] = "api.heclouds.com";

EthernetInterface eth;          //create ethernet
TCPSocketConnection sock;       

MotionSensorDataCounts mag_raw;
MotionSensorDataCounts acc_raw;


void hal_map( MotionSensorDataCounts * acc_raw, MotionSensorDataCounts * mag_raw)
{
int16_t t;
// swap and negate X & Y axis
t = acc_raw->x;
acc_raw->x = acc_raw->y * -1;
acc_raw->y = t * -1;
// swap mag X & Y axis
t = mag_raw->x;
mag_raw->x = mag_raw->y;
mag_raw->y = t;
// negate mag Z axis
mag_raw->z *= -1;
}

void creat_cmd()
{
    char tmp[30];
    char str[100];

    sprintf(str,",;roll,%d;pitch,%d;yaw,%d", axis6.roll, axis6.pitch, axis6.yaw);
    http_cmd[0] = 0;
    strcat(http_cmd,"POST /devices/");
    strcat(http_cmd,devid);
    strcat(http_cmd,"/datapoints?type=5 HTTP/1.1\r\n");
    strcat(http_cmd,"api-key:");
    strcat(http_cmd,api_key);
    strcat(http_cmd,"\r\n");
    strcat(http_cmd,"Host:");
    strcat(http_cmd,host);
    strcat(http_cmd,"\r\n");
    sprintf(tmp,"Content-Length:%d\r\n\r\n", strlen(str));
    strcat(http_cmd,tmp);
    strcat(http_cmd,str);
}

//
// Print data values for debug
//
void debug_print(void)
{
    // Some useful printf statements for debug
    printf("roll=%d, pitch=%d, yaw=%d\r\n", axis6.roll, axis6.pitch, axis6.yaw);
    printf("Acc: X= %2.3f Y= %2.3f Z= %2.3f    ", axis6.fGax, axis6.fGay, axis6.fGaz);
    printf("Mag: X= %4.1f Y= %4.1f Z= %4.1f\r\n\r\n", axis6.fUTmx, axis6.fUTmy, axis6.fUTmz);
    printf("Quaternion: Q0= %1.4f Q1= %1.4f Q2= %1.4f Q3= %1.4f\r\n\r\n", axis6.q0, axis6.q1, axis6.q2, axis6.q3); 
}


void compass_thread(void const *argument) 
{
    // get raw data from the sensors
    acc.getAxis( acc_raw);
    mag.getAxis( mag_raw);
    if(tcount) compass.run( acc_raw, mag_raw); // calculate the eCompass
    if(l++ >= 50) 
    {
         // take car of business once a second
        seconds++;
        sflag = 1;
        compass.calibrate();
        debug_print();
        l = 0;
        
        if(sock.is_connected()) 
        {
            green = 0;
            red = 1;
            creat_cmd();
            sock.send(http_cmd, strlen(http_cmd));
            //printf("%s\r\n",http_cmd);
        }
        else
        {
            green = 1;
            red = 0;
            sock.close();
            
            wait(3);
            
            printf("IP Address is %s\r\n", eth.getIPAddress());
            sock.connect("api.heclouds.com", 80);   //connetct to OneNET
            
            printf("reconnect the server\r\n");
            while(!sock.is_connected());
        }
        
    }
    tcount++;
}


int main() 
{
    RtosTimer compass_timer(compass_thread, osTimerPeriodic);
    
    /* ethernet init */
    eth.init(); //DHCP
    eth.connect();
    printf("IP Address is %s\r\n", eth.getIPAddress());
    sock.connect("api.heclouds.com", 80);   //connetct to OneNET

    printf("\r\n\n\n\n\n\n\n");
    printf("Who AM I= %X\r\n", acc.whoAmI());
    acc.enable();
    
    acc.getAxis( acc_raw);
    mag.getAxis( mag_raw);
    
    compass_timer.start(20); // Run the Compass every 20ms
    while(1) 
    {
        //Thread::wait(osWaitForever);
        /**********receive response data*******************/
        char buffer[300];
        int ret = 0;
        buffer[0] = '\0';
        if(sock.is_connected())
        {
            ret = sock.receive(buffer, sizeof(buffer)-1);
            if(ret >= 0) 
            {
                buffer[ret] = '\0';
            }
            //printf("Received %d chars from server:\r\n%s\r\n", ret, buffer);
        }
        else
        {
            wait(3);
        }
    }  
}
