#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
Serial out(USBTX, USBRX);
EthernetNetIf eth;  
HTTPServer svr;
LocalFileSystem local("local");
DigitalOut led1(LED1);

int main() {
  out.printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    out.printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  out.printf("Setup OK\n");
   
  FILE *fp = fopen("/local/index.htm", "w");  // Open "out.txt" on the local file system for writing
  fprintf(fp, "<html><head><title>Hello World online</title></head><body><h1>Hello World from Mbed NXP LPC1768!</h1></body></html>");
  fclose(fp);
  
  FSHandler::mount("/local/index.htm", "/"); //Mount /webfs path on web root path
  
     
  svr.addHandler<SimpleHandler>("/"); //Default handler
  svr.bind(80);
  
  out.printf("Listening...\n");
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      tm.start();
    }
  }
  
  return 0;
}
