//=================================================================
// Implementation for the player module
//
// Copyright 2020 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.
//==================================================================
#include "player_private.h"

PLAYER player; // structure of player

PLAYER player_get_info(void){
    return(player);
}

void player_init(void) {    
    player.y = 64;
    player.height = 8;
    player.score = 0;
    player.knife_length = 3;
    player.knife_boundingBox.topLeft.x = 9;
    player.knife_boundingBox.topLeft.y = 64;
    player.knife_boundingBox.bottomRight.x = 12;
    player.knife_boundingBox.bottomRight.y = 67;
    player.player_has_knife = 1;
    player_draw(0xFFFFFF);
    return;
}

void player_moveUp(void) { 
    if ((player.y >= 14)&&(player.y <= 127)) {
        int temp = player.y;
        player.y = player.y - player.height;
        player_draw(BLUE);
        uLCD.filled_rectangle(0,temp,player.height, temp+player.height, BLACK);
    }
    if (player.player_has_knife == 1) {
        player_knife_return();
    }
    return;
}

void player_moveDown(void) { 
    if (player.y + player.height <= 127 - get_compost_tallest_height()) {
        int temp = player.y;
        player.y = player.y + player.height;
        player_draw(BLUE);
        uLCD.filled_rectangle(0,temp,player.height, temp+player.height, BLACK);
    }
    if (player.player_has_knife == 1) {
        player_knife_return();
    }
    return;
}

void player_throw(void) { 
    player.player_has_knife = 0;
    return;
}

void player_knife_draw(void) {
    uLCD.filled_rectangle(player.knife_boundingBox.topLeft.x, player.knife_boundingBox.topLeft.y, player.knife_boundingBox.bottomRight.x, player.knife_boundingBox.bottomRight.y, RED);
}

void player_knife_return(void) {
    boundingBox temp = player.knife_boundingBox;
    player.knife_boundingBox.topLeft.x = 8;
    player.knife_boundingBox.topLeft.y = player.y;
    player.knife_boundingBox.bottomRight.x = 11;
    player.knife_boundingBox.bottomRight.y = player.y + 3;
    player.player_has_knife = 1;
    player_knife_draw();
    uLCD.filled_rectangle(temp.topLeft.x, temp.topLeft.y, temp.bottomRight.x, temp.bottomRight.y, BLACK);
}

// ==== player_private.h implementation ====
void player_draw(int color) {
    uLCD.filled_rectangle(0, player.y, player.height, player.y + player.height, color); 
}

void player_score_inc(void) {
    player.score ++;
}

void knife_move(void) {
    if (player.player_has_knife == 0) {
        boundingBox tempBox = player.knife_boundingBox;
        player.knife_boundingBox.topLeft.x += 9;
        player.knife_boundingBox.bottomRight.x += 9;
        player_knife_draw();
        uLCD.filled_rectangle(tempBox.topLeft.x, tempBox.topLeft.y, tempBox.bottomRight.x, tempBox.bottomRight.y, BLACK);
    }
}