//=================================================================
// Implementation for DLL module.
//
// Copyright 2021 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.
//=================================================================
#include <stdlib.h>
#include <stdio.h>
#include "doubly_linked_list.h"

LLNode* create_llnode(void* data) {
  LLNode* node = (LLNode*)malloc(sizeof(LLNode));
  node -> prev = NULL;
  node -> next = NULL;
  node -> data = data;
  return node;
  }


DLinkedList* create_dlinkedlist(void) {
    DLinkedList* newList = (DLinkedList*)malloc(sizeof(DLinkedList));
    newList->head = NULL;
    newList->tail = NULL;
    newList->size = 0;
    return newList;
}

int getSize(DLinkedList* dLinkedList){
  return dLinkedList -> size;
}

LLNode* getHead(DLinkedList* dLinkedList){
  return dLinkedList -> head;
}

LLNode* getTail(DLinkedList* dLinkedList){
  return dLinkedList -> tail;
}

LLNode* getNext(LLNode* node){
  return node -> next;
}

LLNode* getPrev(LLNode* node){
  return node -> prev;
}

void* getData(LLNode* node){
  return node -> data;
}

void insertAfter(DLinkedList* dLinkedList, LLNode* prev_node, void* data){
  if (prev_node == NULL) {
    printf("the given previous node cannot be NULL");
    return;
  }
  LLNode* newNode = create_llnode(data); //creates new node
  LLNode* nextNode = prev_node -> next; //creates next for new node
  //previous node is passed as argument
  if (nextNode != NULL) { //if prev_node is not the tail...
    newNode -> next = nextNode; //update next of new node
    nextNode -> prev = newNode; //update prev of next_node
  } else { //if prev_node is the tail
    dLinkedList -> tail = newNode; //update tail of linked list
  } // execute no matter what
  newNode -> prev = prev_node; //update prev of new node
  prev_node -> next = newNode; //update next of prev_node
  (dLinkedList -> size)++; //update size of linked list
  return;
}

void insertBefore(DLinkedList* dLinkedList, LLNode* next_node, void* data){
  if (next_node == NULL) {
    printf("the given next node cannot be NULL");
    return;
  }
  LLNode* newNode = create_llnode(data); //creates new node
  LLNode* prevNode = next_node -> prev; //creates prev for new node
  //next node is passed as argument
  if (prevNode != NULL) { //if next_node is not the head...
    newNode -> prev = prevNode; //update prev of new node
    prevNode -> next = newNode; //update next of prev node
  } else { //if next_node is the head
    dLinkedList -> head = newNode; //update head of linked list
  } // execute no matter what
  newNode -> next = next_node; //update next of new node
  next_node -> prev = newNode; //update prev of next_node
  (dLinkedList -> size)++; //update size of linked list
  return;
}

void insertHead(DLinkedList* dLinkedList, void* data) {
  if (dLinkedList -> head == NULL) {
    LLNode* newNode = create_llnode(data);
    dLinkedList -> head = newNode;
    dLinkedList -> tail = newNode;
    (dLinkedList -> size)++;
  } else {
    insertBefore(dLinkedList, dLinkedList -> head, data);
  }
}

void insertTail(DLinkedList* dLinkedList, void* data) {
  if (dLinkedList -> head == NULL ){
    LLNode* newNode = create_llnode(data);
    dLinkedList -> head = newNode;
    dLinkedList -> tail = newNode;
    (dLinkedList -> size)++;
  } else {
    insertAfter(dLinkedList, dLinkedList->tail, data);
  }
}

void deleteNode(DLinkedList* dLinkedList, LLNode* Node){
  //LLNode* prevNode = Node -> prev;
  //LLNode* nextNode = Node -> next;
  if (dLinkedList -> size == 1){
      free(Node->data);
      free(Node);
      (dLinkedList->size)--;
      return;
  }
  if (dLinkedList -> head == Node) {
    Node -> next -> prev = NULL;
    dLinkedList -> head = Node -> next;
  } else if (dLinkedList -> tail == Node) {
    Node -> prev -> next = NULL;
    dLinkedList -> tail = Node -> prev;
  } else {
    Node -> prev -> next = Node -> next;
    Node -> next -> prev = Node -> prev;
  }
  (dLinkedList -> size)--;
  free(Node -> data);
  free(Node);
  return;
}

void destroyList(DLinkedList* dLinkedList){
    if ((dLinkedList -> size) == 1) {
        deleteNode(dLinkedList, dLinkedList -> head);
        free(dLinkedList);
        return;
    }     
  LLNode* curr = dLinkedList -> head;
  if (curr == NULL) {
    free(dLinkedList);
    return;
  }
  LLNode* next = curr -> next;
  while (next != NULL) {
    deleteNode(dLinkedList, curr);
    curr = next;
    next = curr -> next;
  }
  free(dLinkedList);
  return;
}

void reverse(DLinkedList* dLinkedList){
  if (dLinkedList -> size <= 1){
    return;
  }
  LLNode* curr = dLinkedList -> head;
  LLNode* start = dLinkedList -> head;
  LLNode* dummy;
  while (curr != NULL){
    dummy = curr -> prev;
    curr -> prev = curr -> next;
    curr -> next = dummy;
    curr = curr -> prev;
  }
  dLinkedList -> head = dLinkedList -> tail;
  dLinkedList -> tail = start;
  return;
}
