//=================================================================
// The file is for module "compost pile"
//
// Copyright 2020 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.
//==================================================================

#include "compost_pile_private.h"
#include "player_public.h"

COMPOST compost_record[NUM_PILE];
int tallest_pile_height;


// See the comments in compost_pile_public.h
void compost_pile_init() {
    COMPOST initialCompost;
    initialCompost.y = 127;
    initialCompost.width = 11;
    initialCompost.height = 2;
    for (int i = 0; i < NUM_PILE; i++) {
        compost_record[i] = initialCompost;
        compost_record[i].x = i*11+6;
    }
    tallest_pile_height = 2;
    draw_compost();
}

COMPOST compost_get_info(int index){
    return(compost_record[index]);
}

void compost_add(int index) {
    if (index < NUM_PILE) {
        compost_record[index].height += 8;
    }
    if (compost_record[index].height > tallest_pile_height) {
        tallest_pile_height = compost_record[index].height;
    }
    if (player_get_info().y > 127 - tallest_pile_height) {
        player_moveUp();
    }
}

void draw_compost(void){
    COMPOST c;
    for (int i = 0; i < NUM_PILE; i++) {
        c = compost_record[i];
        uLCD.filled_rectangle(c.x, c.y-c.height, c.x+c.width, c.y, GREEN);
    }
    return;
}

int get_compost_tallest_height(void){
    return tallest_pile_height;
}


int get_compost_height(int index){
    return compost_record[index].height;
}
