#ifndef LEDLIB_H
#define LEDLIB_H
 
#include "mbed.h"
 
/** LED class.
 *  Collection of supporrt functions for the second lab in the course ET095G at Mittuniversitetet.
 *
 *  To use the library, its header file needs to be included and an object of the LED class created.
 *
 *  Example:
 *  @code
 * #include "mbed.h"
 * #include "Led.h"
 *
 * LED myled(PF4);
 *
 * int main(){
 *  while(1){
 *  wait(5);
 *  myled.on();   //Turns the led on
 *  wait(5);
 *  myled.blink(1); //Blinks the led for 0.2 seconds
 *  wait(5);
 *  myled.toggle();   //Toggles the state of the led (turns it off)
 *  }
 *  @endcode
 */
 
class LED {
    public:
        /** The constructor creates an instance of the LED class. It is automatically called when a new object is declared.
        * @param PinName pin = (The pin that is used).
        */    
        LED(PinName pin);
        
        /** This function sets LED0(i.e., turns it on).
         */
        void on();
        
        /** This function clears LED0 (i.e., turns it off).
         */
        void off();
        
        /** This function toggles LED0 (i.e., it inverts its current state).
         */
        void toggle();
        
        /** This function toggles LED0 on and off in an intervall set by the user.
        * @param sec intervall time for led blink in seconds.
        */        
        void blink(float sec);
        
    private:
        /** LED0 is the lamp on the board
        */
        DigitalOut LED0;
};
 
#endif