#ifndef _SOFT_PWM_
#define _SOFT_PWM_

#include "mbed.h"

class SoftPwm
{
    private:
        float period; // The period of the PWM cycle.
        float dutyCycle; // Duty cycle.
        Timer timer; // A timer for keeping track of where in the cycle we are.
    public:
        // Constructor. The initial period and duty cycle should be given.
        SoftPwm(float initialPeriod, float initialDutycycle);
        
        // getPeriod: Return the current cycle period.
        float getPeriod();
        // getDutyCycle: Return the current duty cycle.
        float getDutyCycle();
        
        // setPeriod: Change the current cycle period.
        void setPeriod(float newPeriod);
        // setDutyCycle: Change the current duty cycle.
        void setDutyCycle(float newDutyCycle);
        
        // isOn: Looks at the current value of the timer and returns true if currently
        // in the on-phase and false if currently in the off-phase.
        bool isOn();        
};

#endif

