#include "soft_pwm.h"

SoftPwm::SoftPwm(float initialPeriod, float initialDutyCycle)
{
    this->period = initialPeriod;
    this->dutyCycle = initialDutyCycle;
    this->timer.start();
}

void SoftPwm::setPeriod(float newPeriod)
{
    this->period = newPeriod;
}

void SoftPwm::setDutyCycle(float newDutyCycle)
{
    this->dutyCycle = newDutyCycle;
}

float SoftPwm::getDutyCycle()
{
    return this->dutyCycle;
}

float SoftPwm::getPeriod()
{
    return this->period;
}

bool SoftPwm::isOn()
{
    
    // Calculate the length of the on-phase.
    float onPhaseDuration = this->dutyCycle * this->period;
    // Store the current time value in a local variable.
    float currentTime = this->timer.read();
    
    if (currentTime > this->period) {
        this->timer.reset();
    }
    
    if (currentTime < onPhaseDuration) {
        return true;
    } else { 
        return false;
    }
}
    