#include "button.h"

// Button constructor.
Button::Button(string name)
{
    // Set the "pin" attribute to a DigitalIn object corresponding
    // to the pin for the selected button (only one button at the
    // moment. 
    if (name == "user") {
        
        this->pin = new DigitalIn(PA_0);
    }
}

// isPressed method: Return true if the button is currently pressed
// and false otherwise.
bool Button::isPressed()
{
    // Get current state of the pin.
    int pinValue = this->pin->read();
    
    // Check the value returned from this->pin->read() and return true or false.
    if (pinValue == 1) {
        return true;
    } else {
        return false;
    }
}


float Button::getPulse(float timeout)
{
    // Create & start a timer.
    Timer timer;
    timer.start();
    
    // Wait for the button to be pressed.
    while(this->isPressed() == false) {
        // If a timeout was specified AND we've waited longer than
        // the specified value, return -1.
        if (timeout != -1.0f && timer.read() > timeout) {
            return -1.0f;
        }
    }
    
    // Reset timer to zero
    timer.reset();
      
    // Wait for the button to be released.
    while(this->isPressed() == true) {
        wait(0.01f);
    }
    
    // Stop the timer and return number of seconds elapsed.
    timer.stop();
    return timer.read();
}