#include "led.h"
#include <vector>

// Led class contructor.
Led::Led(string name) {
    if (name == "red") {
        this->pinName = PD_14;
    } else if (name == "green") {
        this->pinName = PD_12;
    } else if (name == "orange") {
        this->pinName = PD_13;
    } else if (name == "blue") {
        this->pinName = PD_15;
    }
    
    this->pin = new DigitalOut(this->pinName);
    this->isOn = false;
}

// Method to switch the LED on.
void Led::On() {
    this->pin->write(1);
    this->isOn = true;
}

// Method to switch the LED off.
void Led::Off() {
    this->pin->write(0);
    this->isOn = false;
}

// Method to get the current state of the LED.
// (true=on, false=off).
bool Led::getIsOn() {
    return this->isOn;
}

