#include "mbed.h"
/* This program reads output from built-in analogue to digital converter (ADC) */

/* Define some useful constants */
#define ON 1
#define OFF 0

/* Create objects for input/output */
AnalogIn pot_reading(p15); /* ADC input is connected to Pin 15 */

/* Create names for lights */
DigitalOut light1(LED1); /* Control LED1 using light1 */
DigitalOut light2(LED2); /* Control LED2 using light2 */
DigitalOut light3(LED3); /* Control LED3 using light3 */
DigitalOut light4(LED4); /* Control LED4 using light4 */

/* Main loop */
int main() 
{
    float reading;  /* A variable is needed to store ADC reading */
    
    /* Define a while loop that runs forever (or until the MBED is reset) */
    while(1)
    {
        reading=pot_reading; /* store reading from the ADC into variable 'reading' */   
        if(reading > 0.5) /* Checks whether value stored in 'reading' is greater than 0.5 */
        {
            light1=ON; /* light1 is turned on when ADC reading exceeds 0.5 */
        }
        else
        {
            light1=OFF; /* light1 is turned off when ADC reading is less than 0.5 */
        }       
        wait(0.1); /* Pause for 0.1 seconds before taking another reading */
    }
}