#include "mbed.h"
#include "Wifi.h"
#include "LSM9DS1.h"
#include "uLCD_4DGL.h"
#include "playSound.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#define PI 3.14159
#define DECLINATION -4.94 // Declination (degrees) in Atlanta,GA.
//DigitalIn pb1(p29);
//DigitalIn pb2(p30);

Serial pc(USBTX, USBRX);
PwmOut red(p22);
PwmOut green(p23);
PwmOut blue(p24);
SDFileSystem sd(p5, p6, p7, p8, "sd");
Wifi fi(p28, p27, p26);
LSM9DS1 IMU(p9, p10, 0xD6, 0x3C);
AnalogOut DACout(p18);                  
wave_player player(&DACout); 
//playSound("/sd/wavfiles/BUZZER.wav");

int main() {
    fi.setupPage();
    IMU.begin();
    if (!IMU.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    IMU.calibrate(1);
    IMU.calibrateMag(0);
    while(1) {
        while(!IMU.gyroAvailable());
        IMU.readGyro();
        pc.printf("mag:   %9f %9f %9f in gauss\n\r", IMU.calcMag(IMU.mx), IMU.calcMag(IMU.my), IMU.calcMag(IMU.mz));
    }
    
     
}
