#include "mbed.h"
#include "ssd.h"
#include "lcd.h"
#include "keypad.h"
#include "ad.h"
#include "i2c.h"
#include "mcp7940n.h"
#include "pwm.h"
#include "rgb.h"
#include "so.h" 
#include "kernel.h"
#include "serial.h"
#include "console.h"
#include "timer.h"

char message(void) {
    lcdCommand(0x80);
    lcdString("Teste kernel 1.0");
    return SUCCESS;
}
char keypad(void) {
    kpDebounce();
    lcdCommand(0xC0);
    lcdNumber(kpRead());
    return REPEAT;
}
char serial(void) {
    char rx=0xff;
    rx = serialRead();
    if (rx != 0xff) {
        lcdCommand(0xC6);
        lcdChar(rx);
    }
    return REPEAT;
}
int globalCounter;
char counter(void) {
    lcdCommand(0xC8);
    lcdNumber(globalCounter);
    globalCounter++;
    return REPEAT;
}

int main(void){
    unsigned int cor=0;
    timerInit();
    rgbInit();
    
    for(;;){
        timerStart(500000);
        rgbColor(cor);
        
        cor++;
        if (cor >7){
            cor = 1;
        }
        timerWait();
    }
}

int mainConsole(void) {
    char rx[2];
    consoleInit();
    serialInit();
    consolePrint("linha1\nlinha2\nlinha3\nserial:");
    consoleUpdate();
    rx[1] = '\0';
    for (;;) {
        rx[0] = serialRead();
        if (rx[0] != 0xff) {
            //movimentar para cima ou baixo
            if (rx[0] == 'w') {
                consoleMoveLine(-1);
            } else if (rx[0] == 's') {
                consoleMoveLine(+1);
            } else {
                consolePrint(rx);
            }
            consoleUpdate();
        }
    }
}


int mainKernel()
{
  process pMessage = {message,0,0};
  process pKeypad = {keypad,10,0};
  process pSerial = {serial,10,0};
  process pCounter = {counter,100,0};
     
    int temp;
    int dummy=0;
    soInit();  
    lcdInit();
    kpInit();
    ssdInit();
    mcpInit();
    kernelInit();
    
  
  kernelAddProc(&pMessage);
  kernelAddProc(&pKeypad);
  kernelAddProc(&pSerial);
  kernelAddProc(&pCounter);

  kernelLoop();

    /*
    wait(0.1f);
    lcdCommand(0x80);
    lcdString("pq+mBed");
    lcdCommand(0xC0);
    lcdString("db   Key:");
    
    mcpStartClock();
    while (true) {
        lcdCommand(0xCA);
        for(temp = 0;temp<10;temp++){
            if(kpRead()&(1<<temp)){      
                lcdNumber(1000000/lkt_notes[temp]);
                //pwmBuzzer(lkt_notes[temp]);
                bz.period(1.0/lkt_notes[temp]);
                //dummy++;
                bz.write(0.50); //50%
                break;
            }
        }
        if(temp == 10){
            lcdChar(' ');
            bz.write(0); //50%
        }
        kpDebounce();
        
        //temp = 6789;
        temp = adRead(2);
        ssdDigit(1,temp/1000%10);
        ssdDigit(0,temp/10000%10);
        temp = adRead(1);
        ssdDigit(3,temp/1000%10);
        ssdDigit(2,temp/10000%10);
        
        
        lcdCommand(0x88);
        temp = getMinutes();
        lcdChar((temp / 10) % 10 + 48);
        lcdChar((temp / 1) % 10 + 48);
        lcdChar(':');
        
        temp = getSeconds();
        lcdChar((temp / 10) % 10 + 48);
        lcdChar((temp / 1) % 10 + 48);
        
        ssdUpdate();
        wait(0.005f);
    }
    */
}