#include "so.h"
//#include "io.h"
#include "lcd.h"
#include "mbed.h"
#include "ssd.h"
//#define LCD_RS_PIN    7
//#define LCD_EN_PIN    6

DigitalOut LCD_RS_PIN(D7);
DigitalOut LCD_EN_PIN(D6);


//Gera um clock no enable
void pulseEnablePin() {
	//digitalWrite(LCD_EN_PIN, HIGH);
	LCD_EN_PIN =1;
	//wait_us(5);
	//digitalWrite(LCD_EN_PIN, LOW);
	LCD_EN_PIN = 0;
//	wait_us(5);
}
//Envia 4 bits e gera um clock no enable
void pushNibble(char value, int rs) {
	ssdOff();
	soWrite(value);
	//digitalWrite(LCD_RS_PIN, rs);
	LCD_RS_PIN = rs;
	pulseEnablePin();
}
//Envia 8 bits em dois pacotes de 4
void pushByte(char value, int rs) {
	ssdOff();
	soWrite(value >> 4);
//	digitalWrite(LCD_RS_PIN, rs);
	LCD_RS_PIN = rs;
	pulseEnablePin();

	soWrite(value & 0x0F);
//	digitalWrite(LCD_RS_PIN, rs);
	LCD_RS_PIN = rs;
	pulseEnablePin();
}
void lcdCommand(char value) {
	pushByte(value, 0);
	wait_us(40);
	if((value==0x03)||(value==0x02)||(value==0x01)){
		wait_ms(2);
	}
}
void lcdPosition(int line, int col) {
	if (line == 0) {
		lcdCommand(0x80 + (col % 16));
	}
	if (line == 1) {
		lcdCommand(0xC0 + (col % 16));
	}
}
void lcdChar(char value) {
	pushByte(value, 1);
	wait_us(80);
}
//Imprime um texto (vetor de char)
void lcdString(char msg[]) {
	int i = 0;
	while (msg[i] != 0) {
		lcdChar(msg[i]);
		i++;
	}
}
void lcdNumber(int value) {
	int i = 10000; //M�ximo 99.999
	while (i > 0) {
		lcdChar((value / i) % 10 + 48);
		i /= 10;
	}
}
// Rotina de incializa��o
void lcdInit() {
//	pinMode(LCD_EN_PIN, OUTPUT);
//	pinMode(LCD_RS_PIN, OUTPUT);
	soInit();
	ssdOff();
	wait_ms(15);
	// Comunica��o come�a em estado incerto
	pushNibble(0x03, 0);
	wait_ms(5);
	pushNibble(0x03, 0);
	wait_us(160);
	pushNibble(0x03, 0);
	wait_us(160);
	// Mudando comunica��o para 4 bits
	pushNibble(0x02, 0);
	wait_ms(10);
	// Configura o display
	lcdCommand(0x28);         //8bits, 2 linhas, fonte: 5x8
	lcdCommand(0x08 + 0x04);  //display on
	lcdCommand(0x01);         //limpar display, voltar p/ posi��o 0
}
