#include "keypad.h"
#include "so.h"
//#include "io.h"
#include "mbed.h"
#include "ssd.h"

#define bitSet(arg,bit) ((arg) |= (1<<bit))
#define bitClr(arg,bit) ((arg) &= ~(1<<bit)) 
#define bitFlp(arg,bit) ((arg) ^= (1<<bit)) 
#define bitTst(arg,bit) ((arg) & (1<<bit)) 

DigitalIn KEY_1(D12);
DigitalIn KEY_2(D13);

static unsigned int keys;

//vetor com o "nome" dos bot�es
//U -> up, L -> left, D -> down, R -> right
//S -> start, s -> select
//a ordem � referente a posi��o dos bot�es
static const char charKey[] = {'U','L','D','R','S','X','Y','A','B','s'};

unsigned int kpRead(void) {
    return keys;
}
char kpReadKey(void){
	int i;
	for(i=0;i<10;i++){
		if (keys&(1<<i)){
			return charKey[i];
		}
	}
	//nenhuma tecla pressionada
	return 0;
}
void kpDebounce(void) {
    int i;
    static unsigned char tempo;
    static unsigned int newRead;
    static unsigned int oldRead;
    newRead = 0;
    ssdOff();
    for(i = 0; i<5; i++){
      soWrite(1<<(i+3));
      if(KEY_1){
        bitSet(newRead,i);
      }
      if(KEY_2){
        bitSet(newRead,(i+5));
      }
    }
    if (oldRead == newRead) {
        tempo--;
    } else {
        tempo = 4;
        oldRead = newRead;
    }
    if (tempo == 0) {
        keys = oldRead;
    }
}
void kpInit(void) {
  soInit();
  //pinMode(12, INPUT);
  //pinMode(13, INPUT);
}
