//#include "derivative.h"
#include "timer.h"
#include "mbed.h"


Timer t;
int interval;

void timerStart(unsigned int count_val){
	// desliga timer para mudar a configura��o de tempo e resetar contador
	//LPTMR0_CSR=0;
	// Configura o tempo de contagem, como o timer usa um clock de 1KHz, cada unidade equivale 1ms
	// Subtrai duas unidades, descontando o overflow e a reinicializa��o
	//LPTMR0_CMR = count_val-2;
	//Liga o timer
	//LPTMR0_CSR |= 1;
	interval = count_val;
	t.start();
	t.reset();
	return;
}
unsigned int timerRead(void){
	return t.read_us();
}
void timerWait(void){
	//Aguarda final da contagem
	while (t.read_us()<=interval);
	t.stop();
	//Desliga o contador
//	LPTMR0_CSR &= ~LPTMR_CSR_TEN_MASK;
}
int timerFinished(void){
	//Verifica se terminou de contar
	//if (LPTMR0_CSR & LPTMR_CSR_TCF_MASK){
	if(t.read_us()>=interval){
		//Se terminou desliga o contador
		//LPTMR0_CSR &= ~LPTMR_CSR_TEN_MASK;
		return 1;
	}else{
		return 0;
	}
}
//gera um atraso de (time) milissegundos
void timerDelay(unsigned int time){
	timerStart(time);
	timerWait();
}
void timerInit(void){
	interval = 0;
	//Liga sistema de clock do timer
    //SIM_SCGC5 |= SIM_SCGC5_LPTMR_MASK;
    //Utiliza oscilador de 1kHz sem prescaller
    //LPTMR0_PSR = LPTMR_PSR_PCS(1)|LPTMR_PSR_PBYP_MASK;
}
