#ifndef DS1307RTC_h
#define DS1307RTC_h

//defini��o dos endere�os
#define SEC     0
#define MINUTES     1
#define HOUR    2
#define WEEKDAY 3
#define DAY     4
#define MONTH   5
#define YEAR    6

    //fun��es do DS1307
    void mcpInit(void);
    void mcpStartClock(void);
    void mcpStopClock(void);
    int dec2bcd(int value);
    int bcd2dec(int value);
    void mcpWriteData(unsigned char value, int address);
    int mcpReadData(int address);

//fun��es de leitura/escrita simplificadas
#define getSeconds()  (bcd2dec(mcpReadData(SEC)& 0x7f))
#define getMinutes()  (bcd2dec(mcpReadData(MINUTES)& 0x7f))
#define getHours()    (bcd2dec(mcpReadData(HOUR)& 0x5f))
#define getWeekDay()  (bcd2dec(mcpReadData(WEEKDAY)& 0x07))
#define getDays()     (bcd2dec(mcpReadData(DAY)& 0x5f))
#define getMonths()   (bcd2dec(mcpReadData(MONTH)& 0x3f))
#define getYears()    (bcd2dec(mcpReadData(YEAR)& 0xff))

#define setSeconds(v) (mcpWriteData(dec2bcd(v,SEC)))
#define setMinutes(v) (mcpWriteData(dec2bcd(v,MINUTES)))
#define setHours(v)   (mcpWriteData(dec2bcd(v,HOUR)))
#define setWeekDay(v) (mcpWriteData(dec2bcd(v,WEEKDAY)))
#define setDays(v)    (mcpWriteData(dec2bcd(v,DAY)))
#define setMonths(v)  (mcpWriteData(dec2bcd(v,MONTH)))
#define setYears(v)   (mcpWriteData(dec2bcd(v,YEAR)))

#endif
