#include "i2c.h"
#include "mcp7940n.h"

//endere�o do dispositivo, deslocado por causa do bit de RW
//1101000 (0x6f<<1)
#define MCP7940N_CTRL_ID (0xde)
#define I2C_WRITE 0
#define I2C_READ  1

int dec2bcd(int value) {
    return ((value / 10 * 16) + (value % 10));
}
int bcd2dec(int value) {
    return ((value / 16 * 10) + (value % 16));
}
void mcpInit(void) {
    i2cInit();
}
void mcpStartClock(void) {
    int seconds;
    seconds = mcpReadData(SEC);
    mcpWriteData(0x80 | seconds,SEC);
    return;
}
void mcpWriteData(unsigned char value, int address) {
    i2cWriteByte(1,0, MCP7940N_CTRL_ID |I2C_WRITE);
    i2cWriteByte(0,0,address);
    i2cWriteByte(0,1,value);
}
int mcpReadData(int address) {
    int result;
    i2cWriteByte(1,0,MCP7940N_CTRL_ID  | I2C_WRITE);
    i2cWriteByte(0,0,address);
    i2cWriteByte(1,0, MCP7940N_CTRL_ID  | I2C_READ);
    result = i2cReadByte(1,1 );
    return result;
}
