#include "kernel.h"
#include "mbed.h"
#include "lcd.h"


#define MIN_INT -30000
Ticker tick;

static process* pool[POOL_SIZE];
//primeiro elemento do buffer
int start;
//�ltimo elemento do buffer
int end;

//adiciona os processos no pool
char kernelAddProc(process* func){
	// adiciona processo somente se houver espa�o livre
	//o fim nunca pode coincidir com o inicio
	if ( ((end+1)%POOL_SIZE) != start){
		//adiciona o novo processo e agenda para executar imediatamente
		func->deadline += func->period;
		pool[end] = func;
		end = (end+1)%POOL_SIZE;
		return SUCCESS; //sucesso
	}
	return FAIL; //falha
}
//inicializa o kernel em conjunto com a controladora de drivers
void kernelInit(void){
	start = 0;
	end = 0;
	tick.attach(&kernelTick, 0.01); // setup ticker to call flip every 0.7 seconds
}
//executa os processos do 'pool' de acordo com seus tempos de execu��o
void kernelLoop(void){
	unsigned int count;
	unsigned int next;
	process* tempProc;
	for(;;){
	if (start != end){
		//Procura a pr�xima fun��o a ser executada com base no tempo
		count = (start+1)%POOL_SIZE;
		next = start;
			while(count!=end){
			if ((pool[count]->deadline) < (pool[next]->deadline)){
				next = count;
			}
			//para poder incrementar e ciclar o contador
			count = (count+1)%POOL_SIZE;
		}
		//troca e coloca o processo com menor tempo como o pr�ximo
		tempProc = pool[next];
		pool[next] = pool[start];
		pool[start] = tempProc;
		while((pool[start]->deadline) > 0){
			//lcdCommand(0xC0);
			//lcdNumber(pool[start]->deadline);
			//coloca a cpu em modo de economia de energia
		}
		//retorna se precisa repetir novamente ou n�o
		switch (pool[start]->function()) {
			case REPEAT:
				kernelAddProc(pool[start]);
				break;
			case FAIL:
				break;
			default: ;
		}
		//pr�xima fun��o
		start = (start + 1) % POOL_SIZE;
		}
	}
}
//atualiza os tempos de execu��o dos processos
void kernelTick(void){
	int proc;
	proc = start;
	while(proc!=end){
		if((pool[proc]->deadline)>(MIN_INT)){
			pool[proc]->deadline--;
		}
		
		proc = (proc+1)%POOL_SIZE;
	}

}
