#include "mbed.h"
#include "MPU6050.h"
 
Serial pc(USBTX, USBRX); // tx, rx
MPU6050 mpu(p9, p10);   //Also disables sleep mode
 
int main() {
    int accdata[3];
    int gyrodata[3];
    
    wait(0.1);
    if (mpu.testConnection())
        pc.printf("MPU connection succeeded\n\r");
    else
        pc.printf("MPU connection failed\n\r");
        
    while(1) {
        mpu.getAcceleroRaw(accdata);
        mpu.getGyroRaw(gyrodata);
        
        pc.printf("Accelero data: X: %d - Y: %d - Z: %d\n\r", accdata[0], accdata[1], accdata[2]);
        pc.printf("Gyro data: X: %d - Y: %d - Z: %d\n\r\n\r", gyrodata[0], gyrodata[1], gyrodata[2]);
        
        wait(1);
    }
        
        
}