#include "mbed.h"
#include "EthernetInterface.h"
#include "Endpoint.h" 
#include "debug.h"
//#include "main.h"
 
#define MBED_DEV_IP       "192.168.5.12"
#define MBED_DEV_MASK     "255.255.255.0"
#define MBED_DEV_GW       "192.168.5.1"
#define ECHO_SERVER_PORT   5000

#define DEST_IP    "192.168.5.2"
#define DEST_PORT  30000

//Serial pc_a(USBTX, USBRX);    // Serial Port Config
 
int EthernetInit(void);
int UDPTransmit(char*,int);

Endpoint dest;  // Pointer to destination
EthernetInterface eth;      // Configure the Ethernet Port (see #define above) to assign an IP Address
 
int EthernetInit (void) {
    
//    pc_a.baud(9600);  // Serial Port Config (9600, 8 data, 1 stop), 
    
    D(printf("Starting Ethernet Configuration\r\n"));
        
    if(eth.init(MBED_DEV_IP, MBED_DEV_MASK, MBED_DEV_GW) != NULL) //Assign a device ip, mask and gateway. Static (no DHCP)
        return -1;      // Error initialising
    
    D(printf("Ethernet Interface Initialised\r\n"));
        
    if(eth.connect(1000) != NULL)
//        return -1;      // Error connecting //##BUG## returns -1 on successful connection
   
    D(printf("IP Address is %s\r\n", eth.getIPAddress()));
    
    // Establish the destination endpoints IP Address / Port
    D(printf("Establish destination endpoints IP Address / Port\r\n"));

    if(dest.set_address(DEST_IP, DEST_PORT) != NULL)
        return -1;      // Error establishing address (DHCP only)
        
    return 0;       // Success
        
}

int UDPTransmit (char *tx_buffer, int len) {

    // Configure a UDP Socket
    D(printf("Configure UDP Socket\r\n"));
    UDPSocket sock;
    
    if(sock.init() != NULL)
        return -1;      // Error initialising socket
        
    D(printf("Socket Initialised\r\n"));

    //##### NEED TO FIX LENGTH, how to know size of TX_Buffer?????
    // Transmit tx_buffer 
    D(printf("Transmit tx buffer. Data: %s || Length: %d\n\r", tx_buffer, len));
    
    
    int res=0;    
    res=sock.sendTo(dest, tx_buffer, len);
    D(printf("Transmitted %d bytes\r\n",res));
    
    if(res < NULL)
        return -1;      // Error transmitting over UDP
          
    return 0;      // Success
}