#ifndef META_H_
#define META_H_

#include "MAX_M8Q.h"
#include "eCompass_Lib.h"

#define _FILENAME "metaData.csv"

extern axis6_t axis6;      // Structure containing 6axis data
extern gpsinfo_t gpsinfo;  // Structure containing GPS data

class MetaData
{
public:
    MetaData();
    virtual ~MetaData();
    
    void outputToCVSstring(void);  // Format all captured data into CVS format
    
    int appendSDcard(void);       // Write the captured data into the end of the file
    int transmitUDP(void);        // Transmit captured data over UDP port

       
protected:

    void    capture6Axis( axis6_t* );    // Capture data from 6Axis sensor
    void    captureGPS( gpsinfo_t* );    // Capture data from GPS sensor
    
    char    CSVOutput[500];     // Output buffer for CSV data

    double  lat;    // GPS Latitude (deg)
    double  lng;    // GPS Longitude (deg)
    double  alt;    // GPS Altitude (m)
    char    NS;     // GPS NS indicator            
    char    EW;     // GPS EW indicator
    double  spd;    // GPS Speed (kmph)
    double  utc;    // GPS UTC time (hhmmss.ss)
    int     dte;    // GPS Date (ddmmyy)

    int     roll, pitch, yaw;    // Roll, Pitch, Yaw and Compass from the eCompass algorithm
    float   fGax, fGay, fGaz;    // Accelerometer data converted to G's
    float   fUTmx, fUTmy, fUTmz; // Magnetometer data converted to UT's
    float   q0, q1, q2, q3;      // Data from Quaternion converted to floating point
 
};

#endif