#include "meta.h"
#include "mbed.h"
#include "eCompass_Lib.h"
#include "MAX_M8Q.h"
#include "debug.h"
#include <string>


// eCompass external declarations
extern axis6_t axis6;   // Structure to store 6Axis data
extern int captureCompass(void const *argument);    // Prototype

extern gpsinfo_t gpsinfo;  // Structure that stores GPS data
extern int captureMAX_M8Q(void); // Prototype

extern int sd_append(char*);    // Prototype

extern int UDPTransmit(char*,int);

// Constructor - builds an object that gathers 6axis and GPS data
MetaData::MetaData()
{
    //while(1){led = !led;wait(0.5);}

    // Capture compass measurement
    D(printf("Starting compass measurement...\r\n"));
    capture6Axis(&axis6);
        

    // Capture GPS measurement
    D(printf("Starting GPS measurement...\r\n"));
    captureGPS(&gpsinfo);
}

MetaData::~MetaData(){}
    
    
void MetaData::capture6Axis(axis6_t* metaAxis6){
    
    // Perform compass measurement
    D(printf("Performing compass measurement\r\n"));
    
    if(captureCompass(""))
        D(printf("compass_thread failed:e001\r\n"));
    
    // Assign compass results to MetaData class
    D(printf("Assigning compass results to MetaData class\r\n"));
    
    // Roll, Pitch, Yaw and Compass from the eCompass algorithm
    roll =  metaAxis6->roll;
    pitch = metaAxis6->pitch;
    yaw = metaAxis6->yaw;
    
    // Accelerometer data converted to G's
    fGax = metaAxis6->fGax;
    fGay = metaAxis6->fGay;
    fGaz = metaAxis6->fGaz;
    
    // Magnetometer data converted to UT's
    fUTmx = metaAxis6->fUTmx;
    fUTmy = metaAxis6->fUTmy;
    fUTmz = metaAxis6->fUTmz;
    
    // Data from Quaternion converted to floating point
    q0 = metaAxis6->q0;
    q1 = metaAxis6->q1;
    q2 = metaAxis6->q2;
    q3 = metaAxis6->q3;
  
    D(printf("Compass data measured & stored\r\n"));
}
    
    
void MetaData::captureGPS(gpsinfo_t* metaGpsinfo){
    
    //Perform GPS Measurement
    D(printf("Performing GPS measurement\r\n"));
    if(captureMAX_M8Q())
        D(printf("GPS (captureMAX_M8Q) failed:e001\r\n"));
    
    // Assign GPS results to MetaData class
    D(printf("Assign GPS results to MetaData class\r\n"));
    
    lat = metaGpsinfo->lat;      // GPS Latitude (deg)
    lng = metaGpsinfo->lng;      // GPS Longitude (deg)
    alt = metaGpsinfo->alt;      // GPS Altitude (m)
    NS  = metaGpsinfo->NS;       // GPS NS indicator            
    EW  = metaGpsinfo->EW;       // GPS EW indicator
    spd = metaGpsinfo->spd;      // GPS Speed (kmph)
    utc = metaGpsinfo->utc;      // GPS UTC time (hhmmss.ss)
    dte = metaGpsinfo->dte;      // GPS Date (ddmmyy)
      
    D(printf("GPS data measured & stored\r\n"));
        
}

void MetaData::outputToCVSstring(void){
    
//    int n;
//    n = sprintf(CSVOutput,"%.5f,"
    sprintf(CSVOutput,"%.5f,"
                        "%.5f,"
                        "%.1f,"
                        "%c,"   
                        "%c,"   
                        "%.3f,"
                        "%.2f,"
                        "%d,"   
                        "%d,"   
                        "%d,"   
                        "%d,"   
                        "%2.3f,"
                        "%2.3f,"
                        "%2.3f,"
                        "%4.1f,"
                        "%4.1f,"
                        "%4.1f,"
                        "%1.4f,"
                        "%1.4f,"
                        "%1.4f,"
                        "%1.4f\r\n",
                        lat,
                        lng,
                        alt,
                        NS,   
                        EW,
                        spd,
                        utc,
                        dte,    
                        roll, 
                        pitch,
                        yaw, 
                        fGax,
                        fGay,
                        fGaz,
                        fUTmx,
                        fUTmy,
                        fUTmz,
                        q0,
                        q1,
                        q2,
                        q3);
                        
    D(printf("CSVOutput: %s\r\n",CSVOutput));
            
}

int MetaData::appendSDcard(void)
{
    return sd_append(CSVOutput);
}

int MetaData::transmitUDP(void)
{
    return UDPTransmit(CSVOutput,sizeof(CSVOutput));
}
            