#include "mbed.h"
#include "meta.h"
#include "debug.h"

extern int eCompass_init(void);
extern int EthernetInit(void);

Serial pc(USBTX, USBRX);
DigitalOut ledr(LED_RED,1);
DigitalOut ledb(LED_BLUE,1);
DigitalOut ledg(LED_GREEN,1);

int main(void)
{
    ledr=0;     // Status that project has started (LED=Red)
    
    // Wait for SD Card to stabalise
    wait(5);
            
    D(printf("Setting up eComapss\r\n"));   
    if (eCompass_init() != NULL)
        D(printf("##!!## Issue setting up compass\r\n"));

    D(printf("Setting up Ethernet Port\r\n"));
    if (EthernetInit() != NULL)
        D(printf("##!!## Issue setting up Ethernet Port\r\n"));
    
    while(1){
        
        ledg=0;      // Status that main loop was reached
            
        printf("Creating MetaData Object\r\n");
        MetaData _metadata;
        
        D(printf("Creating CSV Output\r\n"));
        _metadata.outputToCVSstring();
    
        ledb=!ledb;      // Status that sensor data was gathered
        
        D(printf("Save to CSV file\r\n"));
        if(_metadata.appendSDcard() != NULL)
            D(printf("##!!## Issue writing to SD Card\r\n"));
        
        D(printf("Transmit to UDP\r\n"));
        if(_metadata.transmitUDP() != NULL)
            D(printf("##!!## Issue transmitting over UDP\r\n"));
            
        printf("###done####\r\n\n\n\n\n\n\n");

    }
    
    return -1;
}