#include "mbed.h"
#include "MAX_M8Q.h"
#include "GPS.h"
#include "debug.h"

//------------------------------------------------------------------------------------
/* This example was tested on C027-U20 and C027-G35 with the on board modem. 
   
   Additionally it was tested with a shield where the SARA-G350/U260/U270 RX/TX/PWRON 
   is connected to D0/D1/D4 and the GPS SCL/SDA is connected D15/D15. In this 
   configuration the following platforms were tested (it is likely that others 
   will work as well)
   - U-BLOX:    C027-G35, C027-U20, C027-C20 (for shield set define C027_FORCE_SHIELD)
   - NXP:       LPC1549v2, LPC4088qsb
   - Freescale: FRDM-KL05Z, FRDM-KL25Z, FRDM-KL46Z, FRDM-K64F
   - STM:       NUCLEO-F401RE, NUCLEO-F030R8
                mount resistors SB13/14 1k, SB62/63 0R
 
   ### RLM - MODIFIED TO REMOVE MODEM FUNCTIONALITY                
*/

gpsinfo_t gpsinfo;  // Structure to store GPS data
int captureMAX_M8Q(void); // Prototype

int captureMAX_M8Q(void)
{
    int ret;
#ifdef LARGE_DATA
    char buf[2048] = "";
#else
    char buf[512] = "";
#endif

    // Create the GPS object
    GPSI2C gps;


    D(printf("GPS Loop\r\n"));


    bool GGA_done = false;
    bool RMC_done = false;
    bool VTG_done = false;

    // While required messages are not yet processed
    while(!(GGA_done & RMC_done & VTG_done))
    {
        // Debug - comment normally
        //printf("GGA/RMC/VTG_done:%d\r\n", !(GGA_done & RMC_done & VTG_done));
        
        // Test for valid message from GPS
        if ((ret = gps.getMessage(buf, sizeof(buf))) > 0)
        {
            int len = LENGTH(ret);  //message length
            
            //### Debug - comment normally
            //printf("NMEA: %.*s\r\n", len-2, buf); 
            
            // Test is valid NMEA message
            if ((PROTOCOL(ret) == GPSParser::NMEA) && (len > 6))
            {
                // Test if this is a valid GPS talker
                // talker is $GA=Galileo $GB=Beidou $GL=Glonass $GN=Combined $GP=GPS
                if ((buf[0] == '$') || buf[1] == 'G') {
                    
                    // Assign the 3 letter NMEA message acronym to 's'
                    #define _CHECK_TALKER(s) ((buf[3] == s[0]) && (buf[4] == s[1]) && (buf[5] == s[2]))
                    
                    // Test for GGA NMEA Message
                    if (_CHECK_TALKER("GGA")) {
                        // GGA Message Detected
                        D(printf("GGA NMEA Message Detected:%.*s\r\n",len-2, buf));
                        
                        // Extract NS (GGA, field 3)
                        if(gps.getNmeaItem(3,buf,len,gpsinfo.NS))
                            D(printf("NS: %c\r\n", gpsinfo.NS)); 
                        
                        // Extract EW (GGA, field 5)
                        if(gps.getNmeaItem(5,buf,len,gpsinfo.EW))
                            D(printf("EW: %c\r\n", gpsinfo.EW)); 
                        
                        // Extract Altitude (GGA, field 9)
                        if(gps.getNmeaItem(9,buf,len,gpsinfo.alt))
                            D(printf("Altitude: %.1f\r\n", gpsinfo.alt)); 
                        
                        // Set flag indicating GGA processing complete
                        GGA_done = true;  
                                         
                    } // end GGA NMEA Test
                    
                    // Test for RMC NMEA Message
                    if (_CHECK_TALKER("RMC")) {
                        // RMC Message Detected
                        D(printf("RMC NMEA Message Detected:%.*s\r\n",len-2, buf));
                        
                        // Extract Time (RMC, field 1)
                        if(gps.getNmeaItem(1,buf,len,gpsinfo.utc))
                            D(printf("Time: %.2f\r\n", gpsinfo.utc));
                            
                        // Extract Latitude (RMC, field 3)
                        if(gps.getNmeaAngle(3,buf,len,gpsinfo.lat))
                            D(printf("Latitude: %.5f\r\n", gpsinfo.lat));
                            
                        // Extract Longtitude (RMC, field 5)
                        if(gps.getNmeaAngle(5,buf,len,gpsinfo.lng))
                            D(printf("Longtitude: %.5f\r\n", gpsinfo.lng));
                        
                        // Extract Date (RMC, field 9)
                        if(gps.getNmeaItem(9,buf,len,gpsinfo.dte,10))
                            D(printf("Date: %d\r\n", gpsinfo.dte));
                        
                        // Set flag indicating RMC processing complete
                        RMC_done = true;
                        
                    } // end RMC NMEA Test
                    
                    // Test for VTG NMEA Message
                    if (_CHECK_TALKER("VTG")) {
                        // VTG Message Detected
                        D(printf("VTG NMEA Message Detected:%.*s\r\n",len-2, buf));
                        
                        // Extract Speed_kmph (VTG, field 7)
                        if(gps.getNmeaItem(7,buf,len,gpsinfo.spd))
                            D(printf("Speed: %.3f\r\n", gpsinfo.spd));
                        
                        // Set flag indicating VTG processing complete
                        VTG_done = true;
                        
                    } // end VTG NMEA Test
                } // end GPS Talker Test
            } // end NMEA Test
        } // end Message Test
    } // restart while loop
   
    // All GPS Data has been collected, power off receiver
    D(printf("GPS Data Collected\r\n"));
    
    return(0);
} 
