#include "mbed.h"
#include "EthernetInterface.h"
#include "Endpoint.h" 
 
#define MBED_DEV_IP       "192.168.1.12"
#define MBED_DEV_MASK     "255.255.255.0"
#define MBED_DEV_GW       "192.168.1.1"
#define ECHO_SERVER_PORT   5000

#define DEST_IP    "192.168.1.1"
#define DEST_PORT  5000

Serial pc(USBTX, USBRX);    // Serial Port Config
 
int main (void) {
    
    pc.baud(9600);  // Serial Port Config (9600, 8 data, 1 stop), 
    
    printf("Starting Ethernet Configuration\n");
    
    // Configure the Ethernet Port (see #define above) to assign an IP Address
    EthernetInterface eth;
    eth.init(MBED_DEV_IP, MBED_DEV_MASK, MBED_DEV_GW); //Assign a device ip, mask and gateway. Static (no DHCP)
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    // Establish the destination endpoints IP Address / Port
    printf("Establish destination endpoints IP Address / Port\n");
    Endpoint dest;
    dest.set_address(DEST_IP, DEST_PORT);       

    // Configure a UDP Socket
    printf("Configure UDP Socket\n");
    UDPSocket sock;
    sock.init();

    // TX buffer for UDP interface
    char tx_buffer[] = "#?#?#? Test Data Output #?#?#?";
       
    while (true){
        
        // Transmit tx_buffer 
        printf("Transmit tx buffer. Data: %s\n", tx_buffer);
        sock.sendTo(dest, tx_buffer, sizeof(tx_buffer));

        // Wait 1 second        
        wait(1); 
          
    } 
}