#include "mbed.h"
#include "MPU9250.h"
#include "rtos.h"

SPI spi(p5, p6, p7);// mosi, miso, sclk
mpu9250_spi imu(spi,p8);
Serial pc(USBTX, USBRX);

Thread thread_imu;
const int duration = 3; //[s]
const int Fs = 4; //[kHz]
float mywait = 1/Fs; //[ms]
const int sample_num = 50;
const int repeat_num = duration*Fs*1000/sample_num;
    
uint8_t temp_imuBuffer[14]; /* 2byte * (3type(x, y, z) + 温度 + gyro（x, y, z）) */ 
char stack_a[sample_num*6]={0}; //[x_h, x_l, y_h, y_l, z_h, z_l]
char stack_g[sample_num*6]={0};
int cntnum = -1;
int prevnum = 1;
int NowRead = true;
int writedone = false;
void imuread()
{   
    while(true){
        for(int k=0; k<repeat_num;k++){
            for(int j=0; j<sample_num; j++){    
                imu.ReadRegs(MPUREG_ACCEL_XOUT_H, temp_imuBuffer, 14);  
                //X,Y,Z axis each High and Low      
                for(int i=0; i<3; i++) {                
                    stack_a[6*j+2*i + 0] = (char)temp_imuBuffer[2*i + 0];//上位8bitを代入 //acccel
                    stack_a[6*j+2*i + 1] = (char)temp_imuBuffer[2*i + 1];//下位8bit
                    stack_g[6*j+2*i + 0] = (char)temp_imuBuffer[2*i + 8];//上位8bitを代入 //gyro
                    stack_g[6*j+2*i + 1] = (char)temp_imuBuffer[2*i + 9];//下位8bit
                    //printf("%x\r\n",stack_a[6*j+2+i]);
                }
                Thread::wait(mywait);
            }
            cntnum = k;
            printf("cntnum: %d \r\n",cntnum);
            while(writedone == false){
                printf("read stop now: %d \r\n");
                wait_ms(100);
            }
            writedone = true;
        }      
        NowRead = false;
        break;
    }
}


LocalFileSystem local("local");
int main(){
    pc.baud(460800);
    printf("set up start!\r\n");
    
    FILE *fp = fopen("/local/data.txt", "w");
    
    /* IMU setup */
    int acc_scale = 0, gyro_scale = 0;
    int response = 0;
    /* iMU初期化，LPFの指定 */
    if (imu.init(255, BITS_DLPF_CFG_2100HZ_NOLPF)) {
        printf("initailize error\r\n");
    }
    acc_scale = imu.set_acc_scale(BITS_FS_8G);/* 加速度計測のレンジを指定 */
    printf("set acc scale %d [ g ]\r\n", acc_scale);
    gyro_scale = imu.set_gyro_scale(BITS_FS_1000DPS);/* ジャイロのレンジを指定 */
    printf("set gyro scale = %d [ degree / sec ]\r\n", gyro_scale);
    response = imu.whoami();
    printf("who am i = %d\r\n", response);/* IMUとの通信の確認 0x71(10進数で113)が正常 */
    
    printf("Press [s] to start\r\n"); 
    while (true) { if (pc.readable()) { if (pc.getc() == 's') { break; } } }
    printf("Now start\r\n"); 
    thread_imu.start(imuread);
    
    //Write
    while (NowRead){
        if(cntnum != prevnum){
            for(int j=0; j<sample_num; j++){
                for(int i=0; i<6; i++){
                    fprintf(fp, "%x ", stack_a[6*j+i]);
                }
                for(int i=0; i<6; i++){
                    fprintf(fp, "%x ", stack_g[6*j+i]);
                }
                fprintf(fp, "\r\n");
            }
            prevnum = cntnum;
            printf("prevum: %d \r\n",prevnum);
            writedone = true;
        }
    }
    thread_imu.terminate();
    printf("finish\r\n");
    fclose(fp);
    return 0;
}